/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db.migration.classloader;

import java.net.URL;
import java.net.URLClassLoader;
import org.qubership.atp.dataset.db.migration.classloader.ParentLastClassloader;

public class ChildClassLoader
extends URLClassLoader {
    ClassLoader realParent;

    public ChildClassLoader(URL[] urls, ParentLastClassloader parent, ClassLoader realParent) {
        super(urls, (ClassLoader)parent);
        this.realParent = realParent;
    }

    @Override
    public URL getResource(String name) {
        URL url = this.realParent != null ? this.realParent.getResource(name) : ClassLoader.getSystemResource(name);
        if (url == null) {
            url = this.findResource(name);
        }
        return url;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            Class<?> clazz = super.findLoadedClass(name);
            if (clazz != null) {
                return clazz;
            }
            clazz = super.findClass(name);
            return clazz;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            try {
                return this.realParent.loadClass(name);
            }
            catch (ClassNotFoundException | NoClassDefFoundError ex) {
                ClassNotFoundException detailedException = new ClassNotFoundException(String.format("Error while loading [%s]", name));
                detailedException.addSuppressed(ex);
                throw detailedException;
            }
        }
    }
}

