/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.common.logging.filter;

import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.util.Strings;
import org.qubership.atp.common.logging.adapter.filter.ContentCachingHttpRequest;
import org.qubership.atp.common.logging.adapter.filter.ContentCachingHttpResponse;
import org.qubership.atp.common.logging.config.LoggingProperties;
import org.qubership.atp.common.logging.filter.CommonHttpRequestWrapper;
import org.qubership.atp.common.logging.utils.ContentType;
import org.qubership.atp.common.logging.utils.RegexUtil;
import org.qubership.atp.common.logging.utils.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class LoggingFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(LoggingFilter.class);
    private final LoggingProperties loggingProperties;
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        List<Pattern> ignoreUriList = this.loggingProperties.getIgnoreUriListPatterns();
        if (request instanceof HttpServletRequest && RegexUtil.matchKey(((HttpServletRequest)request).getRequestURI(), ignoreUriList) && response instanceof HttpServletResponse) {
            this.doFilterWithContentCaching(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFilterWithContentCaching(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ContentCachingResponseWrapper wrappedResponse = new ContentCachingResponseWrapper((HttpServletResponse)response);
        if (ContentType.getContentType(((HttpServletRequest)request).getHeader(HEADER_CONTENT_TYPE)).isLoggingAllowed()) {
            CommonHttpRequestWrapper wrappedRequest = new CommonHttpRequestWrapper((HttpServletRequest)request);
            this.logRequest((HttpServletRequest)wrappedRequest);
            chain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
        } else {
            this.logRequest((HttpServletRequest)request);
            chain.doFilter(request, (ServletResponse)wrappedResponse);
        }
        try {
            this.logResponse(wrappedResponse);
        }
        finally {
            wrappedResponse.copyBodyToResponse();
        }
    }

    private void logRequest(HttpServletRequest request) {
        ContentCachingHttpRequest wrappedRequest = null;
        if (request instanceof CommonHttpRequestWrapper) {
            wrappedRequest = new ContentCachingHttpRequest((CommonHttpRequestWrapper)request);
        }
        Boolean isLoggedHeaders = this.loggingProperties.logControllerHeaders();
        List<Pattern> ignoreHeadersPattern = this.loggingProperties.getIgnoreControllerHeaders();
        List<String> logs = request instanceof CommonHttpRequestWrapper ? Util.getLogRequestData(wrappedRequest, isLoggedHeaders, ignoreHeadersPattern) : Util.getLogHttpServletRequestData(request, isLoggedHeaders, ignoreHeadersPattern);
        Util.logMessage(log, String.join((CharSequence)"\n", logs));
    }

    private void logResponse(ContentCachingResponseWrapper wrappedResponse) throws IOException {
        ContentCachingHttpResponse cacheResponse = new ContentCachingHttpResponse(wrappedResponse);
        String body = Strings.isNotEmpty((CharSequence)wrappedResponse.getHeader(HEADER_CONTENT_DISPOSITION)) ? "Body content logging is not allowed for current Content-Disposition" : (ContentType.getContentType(wrappedResponse.getHeader(HEADER_CONTENT_TYPE)).isLoggingAllowed() ? cacheResponse.getBody() : "Body content logging is not allowed for current content type");
        Boolean isLoggedHeaders = this.loggingProperties.logControllerHeaders();
        List<Pattern> ignoreHeadersPattern = this.loggingProperties.getIgnoreControllerHeaders();
        List<String> logs = Util.getLogResponseData(cacheResponse, body, isLoggedHeaders, ignoreHeadersPattern);
        Util.logMessage(log, String.join((CharSequence)"\n", logs));
    }

    public LoggingFilter(LoggingProperties loggingProperties) {
        this.loggingProperties = loggingProperties;
    }
}

