/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.threetenbp.deser.key;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.threetenbp.deser.key.ThreeTenKeyDeserializer;
import java.io.IOException;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.Instant;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.TemporalQuery;

public class InstantKeyDeserializer
extends ThreeTenKeyDeserializer {
    public static final InstantKeyDeserializer INSTANCE = new InstantKeyDeserializer();

    private InstantKeyDeserializer() {
    }

    protected Instant deserialize(String key, DeserializationContext ctxt) throws IOException {
        try {
            return (Instant)DateTimeFormatter.ISO_INSTANT.parse((CharSequence)key, (TemporalQuery)new TemporalQuery<Instant>(){

                public Instant queryFrom(TemporalAccessor temporal) {
                    return Instant.from((TemporalAccessor)temporal);
                }
            });
        }
        catch (DateTimeException e) {
            return (Instant)this._handleDateTimeException(ctxt, Instant.class, e, key);
        }
    }
}

