/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.yaml;

import com.hazelcast.internal.yaml.YamlDomBuilder;
import com.hazelcast.internal.yaml.YamlException;
import com.hazelcast.internal.yaml.YamlNode;
import com.hazelcast.org.snakeyaml.engine.v2.api.Load;
import com.hazelcast.org.snakeyaml.engine.v2.api.LoadSettings;
import java.io.InputStream;
import java.io.Reader;

public final class YamlLoader {
    private YamlLoader() {
    }

    public static YamlNode load(InputStream inputStream, String rootName) {
        try {
            Object document = YamlLoader.getLoad().loadFromInputStream(inputStream);
            return YamlLoader.buildDom(rootName, document);
        }
        catch (Exception ex) {
            throw new YamlException("An error occurred while loading and parsing the YAML stream", ex);
        }
    }

    public static YamlNode load(InputStream inputStream) {
        try {
            Object document = YamlLoader.getLoad().loadFromInputStream(inputStream);
            return YamlLoader.buildDom(document);
        }
        catch (Exception ex) {
            throw new YamlException("An error occurred while loading and parsing the YAML stream", ex);
        }
    }

    public static YamlNode load(Reader reader, String rootName) {
        try {
            Object document = YamlLoader.getLoad().loadFromReader(reader);
            return YamlLoader.buildDom(rootName, document);
        }
        catch (Exception ex) {
            throw new YamlException("An error occurred while loading and parsing the YAML stream", ex);
        }
    }

    public static YamlNode load(Reader reader) {
        try {
            Object document = YamlLoader.getLoad().loadFromReader(reader);
            return YamlLoader.buildDom(document);
        }
        catch (Exception ex) {
            throw new YamlException("An error occurred while loading and parsing the YAML stream", ex);
        }
    }

    public static YamlNode load(String yaml, String rootName) {
        try {
            Object document = YamlLoader.getLoad().loadFromString(yaml);
            return YamlLoader.buildDom(rootName, document);
        }
        catch (Exception ex) {
            throw new YamlException("An error occurred while loading and parsing the YAML string", ex);
        }
    }

    public static YamlNode load(String yaml) {
        try {
            Object document = YamlLoader.getLoad().loadFromString(yaml);
            return YamlLoader.buildDom(document);
        }
        catch (Exception ex) {
            throw new YamlException("An error occurred while loading and parsing the YAML string", ex);
        }
    }

    private static Load getLoad() {
        LoadSettings settings = LoadSettings.builder().build();
        return new Load(settings);
    }

    private static YamlNode buildDom(String rootName, Object document) {
        return YamlDomBuilder.build(document, rootName);
    }

    private static YamlNode buildDom(Object document) {
        return YamlDomBuilder.build(document);
    }
}

