/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.LazyMapEntry;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Map;
import java.util.function.BiFunction;

public class ComputeIfPresentEntryProcessor<K, V>
implements EntryProcessor<K, V, V>,
IdentifiedDataSerializable {
    BiFunction<? super K, ? super V, ? extends V> biFunction;

    public ComputeIfPresentEntryProcessor() {
    }

    public ComputeIfPresentEntryProcessor(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        this.biFunction = biFunction;
    }

    @Override
    public V process(Map.Entry<K, V> entry) {
        V newValue = this.biFunction.apply(entry.getKey(), entry.getValue());
        if (newValue != null) {
            entry.setValue(newValue);
        } else {
            ((LazyMapEntry)entry).remove();
        }
        return newValue;
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 148;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.biFunction);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.biFunction = (BiFunction)in.readObject();
    }
}

