/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.macros.core.calculator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.apache.commons.lang.StringUtils;
import org.qubership.atp.macros.core.calculator.MacrosCalculator;
import org.qubership.atp.macros.core.exception.MacrosCompilationException;
import org.qubership.atp.macros.core.model.Macros;
import org.qubership.atp.macros.core.model.MacrosParameter;
import org.qubership.atp.macros.core.processor.AbstractContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptMacrosCalculator
implements MacrosCalculator {
    private static final Logger log = LoggerFactory.getLogger(ScriptMacrosCalculator.class);
    private final Map<String, CompiledScript> compiledScripts = new HashMap<String, CompiledScript>();
    private final ScriptEngineManager scriptEngineManager;

    @Override
    @Nullable
    public String calculate(@Nonnull Macros macros, @Nullable List<String> arguments, @Nonnull AbstractContext context) {
        ScriptEngine engine = this.scriptEngineManager.getEngineByName(macros.getEngine());
        if (engine instanceof Invocable) {
            try {
                CompiledScript compiledScript = this.compile(engine, macros);
                Bindings bindings = compiledScript.getEngine().createBindings();
                List<String> compiledArguments = this.compileArguments(macros, arguments);
                bindings.put("args", (Object)compiledArguments);
                if (context.getContextParameters() != null) {
                    bindings.put("contextMap", (Object)context.getContextParameters());
                }
                SimpleScriptContext scriptCtx = new SimpleScriptContext();
                scriptCtx.setBindings(bindings, 100);
                compiledScript.eval(scriptCtx);
                return ((Invocable)((Object)compiledScript.getEngine())).invokeMethod(bindings, "main", compiledArguments.toArray()).toString();
            }
            catch (NoSuchMethodException | ScriptException | MacrosCompilationException e) {
                String message = String.format("Error during evaluation of %s macros: %s", macros.getName(), e.getMessage());
                log.error(message, (Throwable)e);
                return message;
            }
        }
        return null;
    }

    private List<String> compileArguments(@Nonnull Macros macros, @Nullable List<String> arguments) {
        ArrayList<String> compiledArguments = new ArrayList<String>();
        List<MacrosParameter> parameters = macros.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            MacrosParameter macrosParameter = parameters.get(i);
            if (arguments != null && arguments.size() - 1 >= i) {
                compiledArguments.add(this.unEscapeQuoteInsideMacroArguments(arguments.get(i)));
                continue;
            }
            if (macrosParameter.getOptional().booleanValue()) continue;
            compiledArguments.add(macrosParameter.getDefaultValue());
        }
        return compiledArguments;
    }

    private String unEscapeQuoteInsideMacroArguments(String agr) {
        return StringUtils.replace((String)agr, (String)"\\'", (String)"'");
    }

    @Nonnull
    private CompiledScript compile(@Nonnull ScriptEngine engine, @Nonnull Macros macros) throws MacrosCompilationException {
        if (engine instanceof Compilable) {
            try {
                String key = macros.getName();
                if (this.compiledScripts.containsKey(key)) {
                    return this.compiledScripts.get(key);
                }
                CompiledScript compiledScript = ((Compilable)((Object)engine)).compile(macros.getContent());
                this.compiledScripts.put(macros.getName(), compiledScript);
                return compiledScript;
            }
            catch (ScriptException e) {
                String message = String.format("Error during compilation of %s macros: %s", macros.getName(), e.getMessage());
                log.error(message, (Throwable)e);
                throw new MacrosCompilationException(message, e);
            }
        }
        String message = String.format("Engine %s is not compilable", macros.getEngine());
        log.error(message);
        throw new MacrosCompilationException(message);
    }

    @Nullable
    public CompiledScript compile(@Nonnull Macros macros) throws MacrosCompilationException {
        ScriptEngine engine = this.scriptEngineManager.getEngineByName(macros.getEngine());
        if (engine instanceof Invocable) {
            CompiledScript compiledScript = this.compile(engine, macros);
            return compiledScript;
        }
        throw new MacrosCompilationException(String.format("Engine %s is not invocable", macros.getEngine()));
    }

    public ScriptMacrosCalculator(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }
}

