/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.macros.core.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.qubership.atp.macros.core.converter.Date2OffsetDateTimeConverter;
import org.qubership.atp.macros.core.converter.OffsetDateTime2DateConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MacrosDtoConvertService {
    private static final Logger log = LoggerFactory.getLogger(MacrosDtoConvertService.class);
    private final ModelMapper modelMapper = new ModelMapper();

    public MacrosDtoConvertService() {
        this.configureModelMapper();
    }

    public ModelMapper getModelMapper() {
        return this.modelMapper;
    }

    public <T> T convert(Object from, Class<T> to) {
        return (T)this.modelMapper.map(from, to);
    }

    public <T> List<T> convertList(List from, Class<T> to) {
        if (from == null) {
            return new ArrayList();
        }
        return from.stream().map(o -> this.convert(o, to)).collect(Collectors.toList());
    }

    public <T> List<T> convertSetToList(Set from, Class<T> to) {
        if (from == null) {
            return new ArrayList();
        }
        return from.stream().map(o -> this.convert(o, to)).collect(Collectors.toList());
    }

    private void configureModelMapper() {
        this.modelMapper.getConfiguration().setSkipNullEnabled(true);
        this.modelMapper.getConfiguration().getConverters().add(new Date2OffsetDateTimeConverter());
        this.modelMapper.getConfiguration().getConverters().add(new OffsetDateTime2DateConverter());
    }
}

