/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.macros.core.processor;

import javax.annotation.Nonnull;
import org.qubership.atp.macros.core.model.Macros;
import org.qubership.atp.macros.core.parser.antlr4.MacrosBaseVisitor;
import org.qubership.atp.macros.core.parser.antlr4.MacrosParser;
import org.qubership.atp.macros.core.processor.AbstractContext;
import org.qubership.atp.macros.core.processor.Evaluator;
import org.qubership.atp.macros.core.processor.MacrosOpeningCounter;
import org.qubership.atp.macros.core.registry.MacroRegistry;

public class MacrosVisitorImpl<T extends AbstractContext<T>>
extends MacrosBaseVisitor<T> {
    protected final MacrosOpeningCounter brackets = new MacrosOpeningCounter();
    protected final MacroRegistry registry;
    protected final Evaluator evaluator;
    protected T state;

    public MacrosVisitorImpl(@Nonnull MacroRegistry registry, @Nonnull Evaluator evaluator, @Nonnull T state) {
        this.registry = registry;
        this.state = state;
        this.evaluator = evaluator;
    }

    @Override
    public T visitText(MacrosParser.TextContext ctx) {
        ((AbstractContext)this.state).strategy.visitText(ctx, (AbstractContext)this.state);
        return this.state;
    }

    @Override
    public T visitQuote(MacrosParser.QuoteContext ctx) {
        ((AbstractContext)this.state).strategy.visitText(ctx, (AbstractContext)this.state);
        return this.state;
    }

    @Override
    public T visitSlash(MacrosParser.SlashContext ctx) {
        ((AbstractContext)this.state).strategy.visitText(ctx, (AbstractContext)this.state);
        return this.state;
    }

    @Override
    public T visitMacroParams(MacrosParser.MacroParamsContext ctx) {
        ((AbstractContext)this.state).strategy.visitText(ctx, (AbstractContext)this.state);
        return this.state;
    }

    @Override
    public T visitMacrosStart(MacrosParser.MacrosStartContext ctx) {
        String macroStart = ctx.MACROS().getText();
        Macros macros = this.registry.getMacros(macroStart.substring(1, macroStart.length() - 1));
        if (macros == null) {
            ((AbstractContext)this.state).strategy.visitText(ctx, (AbstractContext)this.state);
            this.brackets.open();
        } else {
            ((AbstractContext)this.state).strategy.visitMacrosStart(ctx, macros, this);
            this.brackets.goDeeper();
        }
        return this.state;
    }

    @Override
    public T visitMacrosEnd(MacrosParser.MacrosEndContext ctx) {
        if (this.brackets.isGoingUpperOnClose()) {
            ((AbstractContext)this.state).strategy.visitMacrosEnd(ctx, this);
        } else {
            ((AbstractContext)this.state).strategy.visitText(ctx, (AbstractContext)this.state);
        }
        return this.state;
    }

    public String toString() {
        return ((AbstractContext)this.state).toString();
    }
}

