/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.macros.core.processor;

import javax.annotation.Nonnull;
import org.qubership.atp.macros.core.model.Macros;
import org.qubership.atp.macros.core.parser.antlr4.MacrosParser;
import org.qubership.atp.macros.core.processor.AbstractContext;
import org.qubership.atp.macros.core.processor.CtxEvalException;
import org.qubership.atp.macros.core.processor.MacrosVisitorImpl;

interface MacrosVisitorState {
    public static final InMacro IN_MACRO = new InMacro();
    public static final OutsideMacro OUTSIDE_MACRO = new OutsideMacro();

    public <T extends AbstractContext<T>> void visitMacrosStart(@Nonnull MacrosParser.MacrosStartContext var1, @Nonnull Macros var2, @Nonnull MacrosVisitorImpl<T> var3);

    public <T extends AbstractContext<T>> void visitMacrosEnd(@Nonnull MacrosParser.MacrosEndContext var1, @Nonnull MacrosVisitorImpl<T> var2);

    public void visitText(@Nonnull MacrosParser.TextContext var1, @Nonnull AbstractContext var2);

    public void visitText(@Nonnull MacrosParser.QuoteContext var1, @Nonnull AbstractContext var2);

    public void visitText(@Nonnull MacrosParser.SlashContext var1, @Nonnull AbstractContext var2);

    public void visitText(@Nonnull MacrosParser.MacroParamsContext var1, @Nonnull AbstractContext var2);

    public void visitText(@Nonnull MacrosParser.MacrosStartContext var1, @Nonnull AbstractContext var2);

    public void visitText(@Nonnull MacrosParser.MacrosEndContext var1, @Nonnull AbstractContext var2);

    public void assertEvaluationEnded(AbstractContext var1);

    public static class InMacro
    implements MacrosVisitorState {
        @Override
        public <T extends AbstractContext<T>> void visitMacrosStart(@Nonnull MacrosParser.MacrosStartContext ctx, @Nonnull Macros macros, @Nonnull MacrosVisitorImpl<T> processor) throws CtxEvalException {
            processor.state = ((AbstractContext)processor.state).createChildContext(ctx, macros, processor.evaluator);
        }

        @Override
        public <T extends AbstractContext<T>> void visitMacrosEnd(@Nonnull MacrosParser.MacrosEndContext ctx, @Nonnull MacrosVisitorImpl<T> processor) throws CtxEvalException {
            Object state = processor.state;
            ((AbstractContext)state).notifyMacroEnds(ctx);
            ((AbstractContext)state).strategy = OUTSIDE_MACRO;
        }

        @Override
        public void visitText(@Nonnull MacrosParser.TextContext ctx, @Nonnull AbstractContext state) throws CtxEvalException {
            state.pushArguments(ctx);
        }

        @Override
        public void visitText(@Nonnull MacrosParser.QuoteContext ctx, @Nonnull AbstractContext state) throws CtxEvalException {
            state.pushArguments(ctx);
        }

        @Override
        public void visitText(@Nonnull MacrosParser.SlashContext ctx, @Nonnull AbstractContext state) {
            state.pushArguments(ctx);
        }

        @Override
        public void visitText(@Nonnull MacrosParser.MacroParamsContext ctx, @Nonnull AbstractContext state) throws CtxEvalException {
            state.pushArguments(ctx);
        }

        @Override
        public void visitText(@Nonnull MacrosParser.MacrosStartContext ctx, @Nonnull AbstractContext state) {
            state.pushArguments(ctx);
        }

        @Override
        public void visitText(@Nonnull MacrosParser.MacrosEndContext ctx, @Nonnull AbstractContext state) {
            state.pushArguments(ctx);
        }

        @Override
        public void assertEvaluationEnded(AbstractContext state) throws CtxEvalException {
            throw new CtxEvalException("Macro is not ended properly", state);
        }
    }

    public static class OutsideMacro
    implements MacrosVisitorState {
        @Override
        public <T extends AbstractContext<T>> void visitMacrosStart(@Nonnull MacrosParser.MacrosStartContext ctx, @Nonnull Macros macros, @Nonnull MacrosVisitorImpl<T> processor) throws CtxEvalException {
            ((AbstractContext)processor.state).strategy = IN_MACRO;
            ((AbstractContext)processor.state).notifyMacroStarts(ctx, macros, processor.evaluator);
        }

        @Override
        public <T extends AbstractContext<T>> void visitMacrosEnd(@Nonnull MacrosParser.MacrosEndContext ctx, @Nonnull MacrosVisitorImpl<T> processor) throws CtxEvalException {
            Object state = processor.state;
            if (((AbstractContext)state).parent == null) {
                throw new CtxEvalException("Unexpected macro ending: " + (Object)((Object)ctx), (AbstractContext)state);
            }
            Object parent = ((AbstractContext)state).parent;
            ((AbstractContext)parent).reduce(ctx, state);
            ((AbstractContext)parent).notifyMacroEnds(ctx);
            ((AbstractContext)parent).strategy = OUTSIDE_MACRO;
            processor.state = parent;
        }

        @Override
        public void visitText(@Nonnull MacrosParser.TextContext ctx, @Nonnull AbstractContext state) throws CtxEvalException {
            state.pushText(ctx);
        }

        @Override
        public void visitText(@Nonnull MacrosParser.QuoteContext ctx, @Nonnull AbstractContext state) throws CtxEvalException {
            state.pushText(ctx);
        }

        @Override
        public void visitText(@Nonnull MacrosParser.SlashContext ctx, @Nonnull AbstractContext state) throws CtxEvalException {
            state.pushText(ctx);
        }

        @Override
        public void visitText(@Nonnull MacrosParser.MacroParamsContext ctx, @Nonnull AbstractContext state) {
            state.pushText(ctx);
        }

        @Override
        public void visitText(@Nonnull MacrosParser.MacrosStartContext ctx, @Nonnull AbstractContext state) {
            state.pushText(ctx);
        }

        @Override
        public void visitText(@Nonnull MacrosParser.MacrosEndContext ctx, @Nonnull AbstractContext state) {
            state.pushText(ctx);
        }

        @Override
        public void assertEvaluationEnded(AbstractContext state) throws CtxEvalException {
            if (state.parent != null) {
                throw new CtxEvalException("Macro is not closed properly", state);
            }
        }
    }
}

