/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.macros.core.processor;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.tree.ParseTree;
import org.qubership.atp.macros.core.model.Macros;
import org.qubership.atp.macros.core.parser.antlr4.MacrosParser;
import org.qubership.atp.macros.core.processor.AbstractContext;
import org.qubership.atp.macros.core.processor.Evaluator;
import org.springframework.util.StringUtils;

public class SimpleContext
extends AbstractContext<SimpleContext> {
    protected List<String> args = new ArrayList<String>();
    protected SimpleContext reducedChild = null;
    protected List<String> text = new ArrayList<String>();
    protected Macros macro;
    protected Evaluator evaluator;

    public SimpleContext() {
    }

    public SimpleContext(@Nonnull SimpleContext parent, @Nonnull MacrosParser.MacrosStartContext macro, @Nonnull Macros macros, @Nonnull Evaluator evaluator) {
        super(parent, macro, macros, evaluator);
    }

    @Override
    protected void notifyMacroStarts(@Nonnull MacrosParser.MacrosStartContext macro, @Nonnull Macros macros, @Nonnull Evaluator evaluator) {
        this.macro = macros;
        this.evaluator = evaluator;
    }

    protected String getArgument(MacrosParser.MacroArgContext arg) {
        StringBuilder builder = new StringBuilder();
        if (null != arg) {
            int childCount = arg.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                ParseTree child = arg.getChild(i);
                if (child instanceof MacrosParser.TextContext) {
                    builder.append(child.getText());
                    continue;
                }
                if (!(child instanceof MacrosParser.MacrosContext)) continue;
                builder.append(this.evaluator.evaluate(child.getText(), this.createRootContext()));
            }
        }
        return builder.toString();
    }

    @Override
    protected void pushArguments(@Nonnull MacrosParser.MacrosStartContext args) {
        this.args.add(args.getText());
    }

    @Override
    protected void pushArguments(@Nonnull MacrosParser.TextContext args) {
        this.args.add(args.getText());
    }

    @Override
    protected void pushArguments(@Nonnull MacrosParser.QuoteContext args) {
        this.args.add(args.getText());
    }

    @Override
    protected void pushArguments(@Nonnull MacrosParser.SlashContext args) {
        this.args.add(args.getText());
    }

    protected void pushArguments(MacrosParser.MacroParamContext arg) {
        String result = this.getArgument(arg.macroArg());
        if (!StringUtils.isEmpty((Object)result)) {
            this.args.add(this.evaluator.evaluate(result, this.createRootContext()));
        }
    }

    @Override
    protected void pushArguments(@Nonnull MacrosParser.MacroParamsContext args) {
        for (MacrosParser.MacroParamContext arg : args.macroParam()) {
            this.pushArguments(arg);
        }
    }

    @Override
    protected void pushArguments(@Nonnull MacrosParser.MacrosEndContext args) {
        this.args.add(args.getText());
    }

    @Override
    protected void notifyMacroEnds(MacrosParser.MacrosEndContext ctx) {
        if (this.reducedChild != null) {
            String evaluatedArgs = this.evaluator.evaluate(String.join((CharSequence)"", this.args), this.createRootContext());
            this.args.clear();
            this.args.add(evaluatedArgs);
        }
        String result = this.evaluator.evaluate(this.macro, this.args, this);
        this.text.add(result);
        this.resetMacro();
    }

    protected SimpleContext createRootContext() {
        return new SimpleContext();
    }

    @Override
    protected void pushText(@Nonnull MacrosParser.MacrosStartContext text) {
        this.text.add(text.getText());
    }

    @Override
    protected void pushText(@Nonnull MacrosParser.TextContext text) {
        this.text.add(text.getText());
    }

    @Override
    protected void pushText(@Nonnull MacrosParser.QuoteContext text) {
        this.text.add(text.getText());
    }

    @Override
    protected void pushText(@Nonnull MacrosParser.SlashContext text) {
        this.text.add(text.getText());
    }

    @Override
    protected void pushText(@Nonnull MacrosParser.MacroParamsContext text) {
        this.text.add(text.getText());
    }

    @Override
    protected void pushText(@Nonnull MacrosParser.MacrosEndContext text) {
        this.text.add(text.getText());
    }

    @Override
    @Nonnull
    protected SimpleContext createChildContext(@Nonnull MacrosParser.MacrosStartContext ctx, @Nonnull Macros macros, @Nonnull Evaluator evaluator) {
        return new SimpleContext(this, ctx, macros, evaluator);
    }

    @Override
    protected void reduce(@Nonnull MacrosParser.MacrosEndContext ctx, @Nonnull SimpleContext child) {
        this.args.addAll(child.text);
        this.reducedChild = child;
    }

    @Override
    public String getResultOnEvaluationEnd() {
        this.strategy.assertEvaluationEnded(this);
        return String.join((CharSequence)"", this.text);
    }

    protected void resetMacro() {
        this.macro = null;
        this.evaluator = null;
        this.args.clear();
        this.reducedChild = null;
    }

    @Override
    public SimpleContext reset() {
        this.resetMacro();
        this.text.clear();
        return this;
    }
}

