/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.authorities;

import org.dmfs.optional.Absent;
import org.dmfs.optional.Optional;
import org.dmfs.optional.Present;
import org.dmfs.rfc3986.Authority;
import org.dmfs.rfc3986.UriEncoded;

public final class StructuredAuthority
implements Authority {
    private final Optional<UriEncoded> mUserInfo;
    private final UriEncoded mHost;
    private final Optional<Integer> mPort;

    public StructuredAuthority(UriEncoded host) {
        this((Optional<UriEncoded>)Absent.absent(), host, (Optional<Integer>)Absent.absent());
    }

    public StructuredAuthority(UriEncoded host, int port) {
        this((Optional<UriEncoded>)Absent.absent(), host, (Optional<Integer>)new Present((Object)port));
    }

    public StructuredAuthority(UriEncoded userInfo, UriEncoded host) {
        this((Optional<UriEncoded>)new Present((Object)userInfo), host, (Optional<Integer>)Absent.absent());
    }

    public StructuredAuthority(UriEncoded userInfo, UriEncoded host, int port) {
        this((Optional<UriEncoded>)new Present((Object)userInfo), host, (Optional<Integer>)new Present((Object)port));
    }

    public StructuredAuthority(Optional<UriEncoded> userInfo, UriEncoded host, Optional<Integer> port) {
        this.mUserInfo = userInfo;
        this.mHost = host;
        this.mPort = port;
    }

    @Override
    public Optional<? extends UriEncoded> userInfo() {
        return this.mUserInfo;
    }

    @Override
    public UriEncoded host() {
        return this.mHost;
    }

    @Override
    public Optional<Integer> port() {
        return this.mPort;
    }
}

