/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.authorities;

import java.io.UnsupportedEncodingException;
import org.dmfs.optional.Optional;
import org.dmfs.rfc3986.Authority;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.encoding.Precoded;

public final class Text
implements UriEncoded {
    private final Authority mDelegate;
    private String mText;

    public Text(Authority delegate) {
        this.mDelegate = delegate;
    }

    @Override
    public int length() {
        if (this.mText == null) {
            Optional<Integer> optionalPort;
            int len = this.mDelegate.host().length();
            if (this.mDelegate.userInfo().isPresent()) {
                len += ((UriEncoded)this.mDelegate.userInfo().value()).length() + 1;
            }
            if ((optionalPort = this.mDelegate.port()).isPresent()) {
                int port = (Integer)optionalPort.value();
                if (port < 10) {
                    len += 2;
                } else if (port < 100) {
                    len += 3;
                } else if (port < 1000) {
                    len += 4;
                } else if (port < 10000) {
                    len += 5;
                } else if (port < 100000) {
                    len += 6;
                } else {
                    throw new IllegalArgumentException(String.format("Port number %d out of range (<100000)", port));
                }
            }
            return len;
        }
        return this.mText.length();
    }

    @Override
    public char charAt(int i) {
        return this.toString().charAt(i);
    }

    @Override
    public UriEncoded subSequence(int startIndex, int endIndex) {
        if (startIndex == 0 && endIndex == this.toString().length()) {
            return this;
        }
        return new Precoded(this.toString().subSequence(startIndex, endIndex));
    }

    @Override
    public String toString() {
        if (this.mText == null) {
            StringBuilder builder = new StringBuilder(64);
            Optional<? extends UriEncoded> mUserInfo = this.mDelegate.userInfo();
            if (mUserInfo.isPresent()) {
                builder.append(((UriEncoded)mUserInfo.value()).normalized());
                builder.append('@');
            }
            builder.append(this.mDelegate.host().normalized());
            Optional<Integer> port = this.mDelegate.port();
            if (port.isPresent()) {
                builder.append(':');
                builder.append((Integer)port.value());
            }
            this.mText = builder.toString();
        }
        return this.mText;
    }

    @Override
    public UriEncoded normalized() {
        return this;
    }

    @Override
    public CharSequence decoded(String charset) throws UnsupportedEncodingException {
        throw new UnsupportedOperationException("an Authority can't be decoded as a whole");
    }

    @Override
    public CharSequence decoded() {
        throw new UnsupportedOperationException("an Authority can't be decoded as a whole");
    }
}

