/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.encoding;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.encoding.IdempotentEncoded;
import org.dmfs.rfc3986.encoding.Precoded;
import org.dmfs.rfc3986.encoding.utils.FormPercentEncodingOutputStream;
import org.dmfs.rfc3986.validation.CharSets;

public final class FormEncoded
implements UriEncoded {
    private final CharSequence mPlain;
    private final String mCharSet;
    private CharSequence mEncoded;

    public FormEncoded(CharSequence plain) {
        this(plain, "UTF-8");
    }

    public FormEncoded(CharSequence plain, String charSet) {
        this.mPlain = plain;
        this.mCharSet = charSet;
    }

    @Override
    public UriEncoded normalized() {
        return this;
    }

    @Override
    public CharSequence decoded(String charset) {
        return this.mPlain;
    }

    @Override
    public CharSequence decoded() {
        return this.mPlain;
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int i) {
        return this.toString().charAt(i);
    }

    @Override
    public UriEncoded subSequence(int startIndex, int endIndex) {
        if (startIndex == 0 && endIndex == this.toString().length()) {
            return this;
        }
        return new Precoded(this.toString().subSequence(startIndex, endIndex));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof UriEncoded && this.toString().equals(((UriEncoded)obj).normalized().toString());
    }

    @Override
    public String toString() {
        if (this.mEncoded == null) {
            try {
                this.mEncoded = this.encoded(this.mPlain, this.mCharSet);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(String.format("Charset %s not supported by Runtime", this.mCharSet));
            }
        }
        return this.mEncoded.toString();
    }

    private CharSequence encoded(CharSequence charSequence, String charSet) throws UnsupportedEncodingException {
        int len = charSequence.length();
        if (len == 0) {
            return IdempotentEncoded.EMPTY;
        }
        try {
            FormPercentEncodingOutputStream out = new FormPercentEncodingOutputStream(len, CharSets.UNRESERVED);
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, charSet);
            ((Writer)w).append(charSequence);
            ((Writer)w).close();
            return ((Object)out).toString();
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException while operating on CharSequences");
        }
    }
}

