/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.encoding;

import java.io.UnsupportedEncodingException;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.encoding.FormEncoded;
import org.dmfs.rfc3986.encoding.Precoded;
import org.dmfs.rfc3986.parameters.Parameter;
import org.dmfs.rfc3986.parameters.ParameterList;

public final class XWwwFormUrlEncoded
implements UriEncoded {
    private final ParameterList mParams;
    private final String mCharSet;
    private String mText;

    public XWwwFormUrlEncoded(ParameterList params) {
        this(params, "UTF-8");
    }

    public XWwwFormUrlEncoded(ParameterList params, String charset) {
        this.mParams = params;
        this.mCharSet = charset;
    }

    @Override
    public UriEncoded normalized() {
        return this;
    }

    @Override
    public CharSequence decoded(String charset) throws UnsupportedEncodingException {
        throw new UnsupportedOperationException("x-www-form-urlencoded can't be decoded as a whole");
    }

    @Override
    public CharSequence decoded() {
        throw new UnsupportedOperationException("x-www-form-urlencoded can't be decoded as a whole");
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int i) {
        return this.toString().charAt(i);
    }

    @Override
    public UriEncoded subSequence(int startIndex, int endIndex) {
        if (startIndex == 0 && endIndex == this.toString().length()) {
            return this;
        }
        return new Precoded(this.toString().subSequence(startIndex, endIndex));
    }

    @Override
    public String toString() {
        if (this.mText == null) {
            StringBuilder sb = new StringBuilder(256);
            boolean first = true;
            for (Parameter parameter : this.mParams) {
                if (first) {
                    first = false;
                } else {
                    sb.append('&');
                }
                sb.append(new FormEncoded(parameter.name(), this.mCharSet));
                sb.append('=');
                sb.append(new FormEncoded(parameter.textValue(), this.mCharSet));
            }
            this.mText = sb.toString();
        }
        return this.mText;
    }
}

