/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.paths;

import java.util.Iterator;
import org.dmfs.iterators.AbstractConvertedIterator;
import org.dmfs.iterators.ConvertedIterator;
import org.dmfs.iterators.EmptyIterator;
import org.dmfs.rfc3986.Path;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.encoding.Precoded;
import org.dmfs.rfc3986.utils.Split;

public final class EncodedPath
implements Path {
    private static final AbstractConvertedIterator.Converter<UriEncoded, CharSequence> CONVERTER = new AbstractConvertedIterator.Converter<UriEncoded, CharSequence>(){

        public UriEncoded convert(CharSequence element) {
            return new Precoded(element);
        }
    };
    private final CharSequence mPath;

    public EncodedPath(UriEncoded path) {
        this.mPath = path;
    }

    @Override
    public boolean isEmpty() {
        return this.mPath.length() == 0;
    }

    @Override
    public boolean isAbsolute() {
        return this.mPath.length() > 0 && this.mPath.charAt(0) == '/';
    }

    @Override
    public Iterator<UriEncoded> iterator() {
        if (this.isEmpty()) {
            return EmptyIterator.instance();
        }
        return new ConvertedIterator((Iterator)((Object)new Split(this.mPath, '/')), CONVERTER);
    }
}

