/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.queries;

import java.util.NoSuchElementException;
import org.dmfs.optional.Absent;
import org.dmfs.optional.Optional;
import org.dmfs.optional.Present;
import org.dmfs.rfc3986.Query;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.queries.SimpleQuery;
import org.dmfs.rfc3986.utils.Parsed;
import org.dmfs.rfc3986.validation.CharSets;

public final class OptionalLazyQuery
implements Optional<Query>,
Parsed {
    private final UriEncoded mUriEncoded;
    private Optional<Query> mDelegate;
    private int mEnd;

    public OptionalLazyQuery(UriEncoded uriEncoded) {
        this.mUriEncoded = uriEncoded;
    }

    public boolean isPresent() {
        return this.query().isPresent();
    }

    public Query value(Query defaultValue) {
        return (Query)this.query().value((Object)defaultValue);
    }

    public Query value() throws NoSuchElementException {
        return (Query)this.query().value();
    }

    private Optional<Query> query() {
        if (this.mDelegate == null) {
            this.mDelegate = this.parsedQuery();
        }
        return this.mDelegate;
    }

    private Optional<Query> parsedQuery() {
        int i;
        UriEncoded encoded = this.mUriEncoded;
        int count = encoded.length();
        if (count == 0 || encoded.charAt(0) != '?') {
            return Absent.absent();
        }
        for (i = 1; i < count && CharSets.QUERY_CHAR.contains(encoded.charAt(i)); ++i) {
        }
        if (i < count && encoded.charAt(i) != '#') {
            throw new IllegalArgumentException(String.format("Query %s contains illegal char %c at position %d", encoded.toString(), Character.valueOf(encoded.charAt(i)), i));
        }
        this.mEnd = i;
        return new Present((Object)new SimpleQuery(encoded.subSequence(1, i)));
    }

    @Override
    public int parsedLength() {
        this.query();
        return this.mEnd;
    }
}

