/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.config;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.model.Indexes;
import com.mongodb.event.CommandListener;
import com.mongodb.event.ConnectionPoolListener;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.mongodb.MongoMetricsCommandListener;
import io.micrometer.core.instrument.binder.mongodb.MongoMetricsConnectionPoolListener;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bson.UuidRepresentation;
import org.qubership.atp.dataset.db.GridFsRepository;
import org.qubership.atp.dataset.db.GridFsRepositoryImpl;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class GridFsConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(GridFsConfiguration.class);
    @Value(value="${gridfs.database:#{null}}")
    private String database;
    @Value(value="${gridfs.host:#{null}}")
    private String host;
    @Value(value="${gridfs.port:#{null}}")
    private String port;
    @Value(value="${gridfs.user:#{null}}")
    private String user;
    @Value(value="${gridfs.password:#{null}}")
    private String password;

    @Bean
    public GridFsRepository provideRepo(MeterRegistry meterRegistry) {
        try {
            GridFSBucket gridFsBucket = this.provideGridFileSystemBuckets(meterRegistry);
            return new GridFsRepositoryImpl(gridFsBucket);
        }
        catch (Exception e) {
            String message = "Can not initialize grid fs module, will use mock instead";
            LOG.warn(message, (Throwable)e);
            final UnsupportedOperationException exception = new UnsupportedOperationException(message, e);
            return new GridFsRepository(){

                @Override
                public void remove(UUID attachmentUuid) {
                }

                @Override
                public void save(FileData fileData, InputStream fileInputStream) {
                    throw exception;
                }

                @Override
                public Optional<GridFSFile> getGridFsFile(UUID attachmentUuid) {
                    return Optional.empty();
                }

                @Override
                public Optional<InputStream> get(UUID parameterUuid) {
                    return Optional.empty();
                }

                @Override
                public Map<UUID, Optional<InputStream>> getAll(List<UUID> parametersUuids) {
                    return new HashMap<UUID, Optional<InputStream>>();
                }

                @Override
                public Optional<FileData> getFileInfo(UUID parameterUuid) {
                    return Optional.empty();
                }

                @Override
                public void onDeleteCascade(List<UUID> parameters) {
                }

                @Override
                public void dropLocalThreadCache() {
                }
            };
        }
    }

    private GridFSBucket provideGridFileSystemBuckets(MeterRegistry meterRegistry) {
        String mongoClientUri = "mongodb://" + this.user + ":" + this.password + "@" + this.host + ":" + this.port + "/?authSource=" + this.database;
        ConnectionString connectionString = new ConnectionString(mongoClientUri);
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().uuidRepresentation(UuidRepresentation.JAVA_LEGACY).addCommandListener((CommandListener)new MongoMetricsCommandListener(meterRegistry)).applyConnectionString(connectionString).applyToConnectionPoolSettings(builder -> builder.addConnectionPoolListener((ConnectionPoolListener)new MongoMetricsConnectionPoolListener(meterRegistry))).build();
        MongoClient mongo = MongoClients.create((MongoClientSettings)mongoClientSettings);
        MongoDatabase db = mongo.getDatabase(this.database);
        GridFSBucket gridFsBucket = GridFSBuckets.create((MongoDatabase)db);
        MongoCollection filesCollection = db.getCollection("fs.files");
        filesCollection.createIndex(Indexes.descending((String[])new String[]{"metadata.attachmentUuid"}));
        return gridFsBucket;
    }
}

