/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.config;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(value={"service.https.enabled"})
@Configuration
public class HttpsConfig {
    private static final Logger LOG = LoggerFactory.getLogger(HttpsConfig.class);
    @Value(value="${https.port}")
    private int httpsPort;
    @Value(value="${server.http.interface}")
    private String httpInterface;
    @Value(value="${server.ssl.key-store}")
    private String keyStoreLocation;
    @Value(value="${server.ssl.key-store-password}")
    private String keyStorePassword;
    @Value(value="${server.ssl.keyStoreType}")
    private String keyStoreType;

    @Bean
    public WebServerFactoryCustomizer<UndertowServletWebServerFactory> containerCustomizer() {
        return factory -> factory.getBuilderCustomizers().add(builder -> builder.addHttpsListener(this.httpsPort, this.httpInterface, this.sslContext()));
    }

    @Bean
    public KeyStore loadKeyStore() {
        KeyStore keyStore;
        block8: {
            InputStream stream = Files.newInputStream(Paths.get(this.keyStoreLocation, new String[0]), new OpenOption[0]);
            try {
                KeyStore loadedKeystore = KeyStore.getInstance(this.keyStoreType);
                loadedKeystore.load(stream, this.keyStorePassword.toCharArray());
                keyStore = loadedKeystore;
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error("Failed to load keystore.", (Throwable)e);
                    return null;
                }
            }
            stream.close();
        }
        return keyStore;
    }

    @Bean
    public SSLContext sslContext() {
        KeyStore keyStore = this.loadKeyStore();
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, this.keyStorePassword.toCharArray());
            KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to construct SSLContext.", e);
        }
    }
}

