/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.controllers.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.dataset.controllers.api.dto.datasetlists.lazy.DataSetListFlatDto;
import org.qubership.atp.dataset.controllers.api.dto.datasetlists.lazy.RefDataSetListFlatDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="DataSetListLazyLoadingController", description="Data Set List Lazy Loading Controller")
public interface DataSetListLazyLoadingControllerApi {
    @Operation(operationId="getDataSetListFlat", summary="Returns information about the selected DSL.", tags={"data-set-list-lazy-loading-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataSetListFlatDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/dsl/lazy/{dataSetListId}"}, produces={"application/json"})
    public ResponseEntity<DataSetListFlatDto> getDataSetListFlat(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1);

    @Operation(operationId="getReferencedDataSetList", summary="Returns information about the selected DSL.", tags={"data-set-list-lazy-loading-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=RefDataSetListFlatDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/dsl/lazy/{dataSetListId}/ReferenceByPath/{attributePath}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<RefDataSetListFlatDto> getReferencedDataSetList(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1, @Parameter(name="attributePath", description="attributePath", required=true) @PathVariable(value="attributePath") String var2, @Parameter(name="page", description="") @Valid @RequestParam(value="page", required=false) Integer var3, @Parameter(name="size", description="") @Valid @RequestParam(value="size", required=false) Integer var4, @Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var5);

    @Operation(operationId="getReferencedDataSetListRows", summary="Returns information about the selected DSL.", tags={"data-set-list-lazy-loading-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=RefDataSetListFlatDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/dsl/lazy/{dataSetListId}/ReferenceByPath/rows/{attributePath}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<RefDataSetListFlatDto> getReferencedDataSetListRows(@Parameter(name="dataSetListId", description="dataSetListId", required=true) @PathVariable(value="dataSetListId") UUID var1, @Parameter(name="attributePath", description="attributePath", required=true) @PathVariable(value="attributePath") String var2, @Parameter(name="page", description="") @Valid @RequestParam(value="page", required=false) Integer var3, @Parameter(name="size", description="") @Valid @RequestParam(value="size", required=false) Integer var4, @Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var5);
}

