/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.controllers.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.dataset.controllers.api.dto.labels.FilterDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="LabelFilterController", description="Label Filter Controller")
public interface LabelFilterControllerApi {
    @Operation(operationId="createFilter", summary="Create new filter", tags={"label-filter-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=FilterDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/filter/create"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FilterDto> createFilter(@NotNull @Parameter(name="name", description="name", required=true) @Valid @RequestParam(value="name", required=true) String var1, @NotNull @Parameter(name="vaId", description="vaId", required=true) @Valid @RequestParam(value="vaId", required=true) UUID var2, @Parameter(name="request_body", description="") @Valid @RequestBody(required=false) Map<String, List<UUID>> var3);

    @Operation(operationId="delete", summary="Delete filter by id", tags={"label-filter-controller"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/filter/delete"})
    public ResponseEntity<Void> delete(@NotNull @Parameter(name="filterId", description="filterId", required=true) @Valid @RequestParam(value="filterId", required=true) UUID var1);

    @Operation(operationId="getFilters", summary="Returns all filter under visibility area", tags={"label-filter-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=FilterDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/filter/get"}, produces={"application/json"})
    public ResponseEntity<List<FilterDto>> getFilters(@Parameter(name="vaId", description="vaId") @Valid @RequestParam(value="vaId", required=false) UUID var1);

    @Operation(operationId="update", summary="Update filter name and filter labels", tags={"label-filter-controller"}, responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/filter/update"}, consumes={"application/json"})
    public ResponseEntity<Void> update(@Parameter(name="name", description="name") @Valid @RequestParam(value="name", required=false) String var1, @Parameter(name="filterId", description="filterId") @Valid @RequestParam(value="filterId", required=false) UUID var2, @Parameter(name="request_body", description="") @Valid @RequestBody(required=false) Map<String, List<UUID>> var3);
}

