/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db;

import com.google.common.base.Preconditions;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.qubership.atp.dataset.db.AbstractRepository;
import org.qubership.atp.dataset.db.AttributePathRepository;
import org.qubership.atp.dataset.db.CacheRepository;
import org.qubership.atp.dataset.db.DataSetListRepository;
import org.qubership.atp.dataset.db.LabelRepository;
import org.qubership.atp.dataset.db.ParameterRepository;
import org.qubership.atp.dataset.db.utils.Proxies;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Label;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.impl.DataSetImpl;
import org.qubership.atp.dataset.model.impl.TableResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DataSetRepository
extends AbstractRepository {
    private final Provider<DataSetListRepository> dslRepo;
    private final Provider<ParameterRepository> paramRepo;
    private final Provider<LabelRepository> labelRepo;
    private final CacheRepository cacheRepo;
    private final DataSetProjection projection;
    private final SQLQueryFactory queryFactory;
    private final AttributePathRepository attrPathRepo;

    @Autowired
    public DataSetRepository(@Nonnull SQLQueryFactory queryFactory, @Nonnull Provider<DataSetListRepository> dslRepo, @Nonnull Provider<ParameterRepository> paramRepo, @Nonnull Provider<LabelRepository> labelRepo, @Nonnull AttributePathRepository attrPathRepo, @Nonnull CacheRepository cacheRepo) {
        this.queryFactory = queryFactory;
        this.dslRepo = dslRepo;
        this.paramRepo = paramRepo;
        this.labelRepo = labelRepo;
        this.cacheRepo = cacheRepo;
        this.attrPathRepo = attrPathRepo;
        this.projection = new DataSetProjection(this);
    }

    @Nonnull
    public DataSet create(@Nonnull UUID dslId, @Nonnull String name) {
        UUID id = (UUID)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)DS).set((Path)DataSetRepository.DS.name, (Object)name)).set(DataSetRepository.DS.datasetlistId, (Object)dslId)).set(DataSetRepository.DS.ordering, this.getNextvalOfSequenceDataset())).executeWithKey(DataSetRepository.DS.id);
        Preconditions.checkNotNull((Object)id, (Object)"nothing created");
        return this.projection.create(id, dslId, name, false);
    }

    public boolean restore(@Nonnull UUID dslId, @Nonnull UUID dsId, @Nonnull String name, @Nullable UUID previousDataSet) {
        Long ordering = 0L;
        if (previousDataSet != null) {
            ordering = (Long)((SQLQuery)((SQLQuery)this.queryFactory.select(DataSetRepository.DS.ordering).from((Expression)DS)).where((Predicate)DataSetRepository.DS.id.eq((Object)previousDataSet))).fetchFirst() + 1L;
        }
        return ((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)DS).set(DataSetRepository.DS.id, (Object)dsId)).set((Path)DataSetRepository.DS.name, (Object)name)).set(DataSetRepository.DS.datasetlistId, (Object)dslId)).set(DataSetRepository.DS.ordering, (Object)ordering)).execute() > 0L;
    }

    @Nullable
    public DataSet getById(@Nonnull UUID id) {
        return this.cacheRepo.tryComputeIfAbsent(DataSet.class, id, uuid -> (DataSet)this.select((Predicate)DataSetRepository.DS.id.eq(uuid)).fetchOne());
    }

    public boolean existsById(UUID id) {
        return this.cacheRepo.getIfPresent(DataSet.class, id) != null || this.select((Predicate)DataSetRepository.DS.id.eq((Object)id)).fetchCount() > 0L;
    }

    @Nonnull
    public List<DataSet> getByParentId(@Nonnull UUID dslId) {
        return ((SQLQuery)this.select((Predicate)DataSetRepository.DS.datasetlistId.eq((Object)dslId)).orderBy(DataSetRepository.DS.ordering.asc())).fetch();
    }

    @Nonnull
    public List<String> getOccupiedNamesByParentId(@Nonnull UUID dslId) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)DataSetRepository.DS.name).from((Expression)DS)).where((Predicate)DataSetRepository.DS.datasetlistId.eq((Object)dslId))).fetch();
    }

    @Nonnull
    public List<DataSet> getByParentIdAndLabel(@Nonnull UUID dslId, @Nonnull String labelName) {
        return this.select((Predicate)DataSetRepository.DS.datasetlistId.eq((Object)dslId).and((Predicate)((LabelRepository)this.labelRepo.get()).dsByLabelName(labelName))).fetch();
    }

    @Nonnull
    public List<DataSet> getAll() {
        return ((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)DS)).fetch();
    }

    @Nonnull
    public List<DataSet> getAll(List<UUID> ids) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)DS)).where((Predicate)DataSetRepository.DS.id.in(ids))).fetch();
    }

    @Nonnull
    public SimpleExpression<Long> getNextvalOfSequenceDataset() {
        return SQLExpressions.nextval((String)"SEQUENCE_DATASET");
    }

    @Nonnull
    protected SQLQuery<DataSet> select(@Nonnull Predicate predicate) {
        return (SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)DS)).where(predicate);
    }

    public boolean rename(@Nonnull UUID id, @Nonnull String name) {
        return ((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)DS).where((Predicate)DataSetRepository.DS.id.eq((Object)id))).set((Path)DataSetRepository.DS.name, (Object)name)).execute() > 0L;
    }

    public boolean lock(@Nonnull List<UUID> ids, boolean isLock) {
        return ids.stream().allMatch(id -> ((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)DS).where((Predicate)DataSetRepository.DS.id.eq(id))).set((Path)DataSetRepository.DS.locked, (Object)isLock)).execute() > 0L);
    }

    void onDslDeleteCascade(UUID dslId) {
        this.getByParentId(dslId).forEach(ds -> this.delete(ds.getId()));
    }

    public boolean delete(@Nonnull UUID id) {
        ((ParameterRepository)this.paramRepo.get()).onDsDeleteCascade(id);
        ((LabelRepository)this.labelRepo.get()).onDsDeleteCascade(id);
        this.attrPathRepo.onDsDeleteCascade(id);
        return this.delete((Predicate)DataSetRepository.DS.id.eq((Object)id)) > 0L;
    }

    private long delete(@Nonnull Predicate predicate) {
        return ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)DS).where(predicate)).execute();
    }

    @Nonnull
    public List<DataSet> getAffectedDataSetsByChangesDataSetReference(@Nonnull UUID dataSetId) {
        return this.select((Predicate)DataSetRepository.DS.id.in((SubQueryExpression)((SQLQuery)this.queryFactory.select(DataSetRepository.PARAM.datasetId).from((Expression)PARAM)).where((Predicate)DataSetRepository.PARAM.ds.eq((Object)dataSetId)))).fetch();
    }

    @Nonnull
    public List<?> getAffectedInfoByChangesDataSetReference(@Nonnull UUID dataSetId) {
        List result = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select(new Expression[]{DataSetRepository.DSL.id, DataSetRepository.DSL.name, DataSetRepository.DS.id, DataSetRepository.DS.name, DataSetRepository.PARAM.id, DataSetRepository.PARAM.ds, DataSetRepository.ATTR.id, DataSetRepository.ATTR.name}).from((Expression)PARAM)).where((Predicate)DataSetRepository.PARAM.ds.eq((Object)dataSetId))).leftJoin((EntityPath)DS)).on((Predicate)DataSetRepository.PARAM.datasetId.eq(DataSetRepository.DS.id))).leftJoin((EntityPath)DSL)).on((Predicate)DataSetRepository.DS.datasetlistId.eq(DataSetRepository.DSL.id))).leftJoin((EntityPath)ATTR)).on((Predicate)DataSetRepository.ATTR.id.eq(DataSetRepository.PARAM.attributeId))).fetch();
        return result.stream().map(TableResponse::fromParameterTuple).collect(Collectors.toList());
    }

    @Nonnull
    public Label mark(@Nonnull UUID dsId, @Nonnull String labelName) {
        return ((LabelRepository)this.labelRepo.get()).markDs(dsId, labelName);
    }

    public boolean unmark(@Nonnull UUID dsId, @Nonnull UUID labelId) {
        return ((LabelRepository)this.labelRepo.get()).unmarkDs(dsId, labelId);
    }

    @Nonnull
    public List<Label> getLabels(@Nonnull UUID dsId) {
        return ((LabelRepository)this.labelRepo.get()).getLabelsOfDs(dsId);
    }

    private static class DataSetProjection
    extends MappingProjection<DataSet> {
        private final DataSetRepository repo;

        private DataSetProjection(@Nonnull DataSetRepository repo) {
            super(DataSet.class, (Expression[])AbstractRepository.DS.all());
            this.repo = repo;
        }

        protected DataSetImpl map(Tuple row) {
            UUID id = (UUID)row.get(AbstractRepository.DS.id);
            assert (id != null);
            UUID dslId = (UUID)row.get(AbstractRepository.DS.datasetlistId);
            assert (dslId != null);
            Boolean locked = (Boolean)row.get((Expression)AbstractRepository.DS.locked);
            return this.create(id, dslId, (String)row.get((Expression)AbstractRepository.DS.name), locked);
        }

        private DataSetImpl create(UUID id, UUID dslId, String name, Boolean locked) {
            DataSetList dsl = Proxies.withId(DataSetList.class, dslId, uuid -> ((DataSetListRepository)this.repo.dslRepo.get()).getById((UUID)uuid));
            List<Parameter> parameters = Proxies.list(() -> ((ParameterRepository)this.repo.paramRepo.get()).getByDataSetId(id));
            List<Label> labels = Proxies.list(() -> ((LabelRepository)this.repo.labelRepo.get()).getLabelsOfDs(id));
            return new DataSetImpl(id, name, dsl, parameters, labels, locked);
        }
    }
}

