/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db;

import com.google.common.base.Preconditions;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.model.Identified;

public interface IdentifiedCache {
    @Nonnull
    default public <T extends Identified> T computeIfAbsent(@Nonnull Class<T> type, @Nonnull UUID id, @Nonnull Function<UUID, ? extends T> sourceFunc) {
        T result = this.tryComputeIfAbsent(type, id, sourceFunc);
        Preconditions.checkNotNull(result, (String)"[%s] with id [%s] is not provided by [%s]", type, (Object)id, sourceFunc);
        return result;
    }

    @Nullable
    default public <T extends Identified> T tryComputeIfAbsent(@Nonnull Class<T> type, @Nonnull UUID id, @Nonnull Function<UUID, ? extends T> sourceFunc) {
        Object result = this.getIfPresent(type, id);
        if (result != null) {
            return result;
        }
        result = (Identified)sourceFunc.apply(id);
        if (result != null) {
            this.put(type, result);
        }
        return result;
    }

    @Nullable
    public <T extends Identified> T getIfPresent(@Nonnull Class<T> var1, @Nonnull UUID var2);

    public <T extends Identified> void put(@Nonnull Class<T> var1, @Nonnull T var2);

    public void clear();
}

