/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db;

import com.google.common.base.Preconditions;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.qubership.atp.dataset.db.AbstractRepository;
import org.qubership.atp.dataset.db.CacheRepository;
import org.qubership.atp.dataset.db.DataSetListRepository;
import org.qubership.atp.dataset.db.FilterRepository;
import org.qubership.atp.dataset.db.TestPlanRepository;
import org.qubership.atp.dataset.db.utils.Proxies;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.model.impl.VisibilityAreaImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class VisibilityAreaRepository
extends AbstractRepository {
    private final Provider<DataSetListRepository> dslRepo;
    private final VisibilityAreaProjection visibilityAreaProjection;
    private final SQLQueryFactory queryFactory;
    private final CacheRepository cacheRepo;
    private final Provider<FilterRepository> filtersRepo;
    private final Provider<TestPlanRepository> testPlanRepo;

    @Autowired
    public VisibilityAreaRepository(@Nonnull SQLQueryFactory queryFactory, @Nonnull Provider<DataSetListRepository> dslRepo, @Nonnull CacheRepository cacheRepo, @Nonnull Provider<FilterRepository> filtersRepo, @Nonnull Provider<TestPlanRepository> testPlanRepo) {
        this.queryFactory = queryFactory;
        this.dslRepo = dslRepo;
        this.cacheRepo = cacheRepo;
        this.testPlanRepo = testPlanRepo;
        this.visibilityAreaProjection = new VisibilityAreaProjection(this);
        this.filtersRepo = filtersRepo;
    }

    @Nonnull
    public VisibilityArea create(@Nonnull String name) {
        UUID vaId = (UUID)Preconditions.checkNotNull((Object)((UUID)((SQLInsertClause)this.queryFactory.insert((RelationalPath)VA).set((Path)VisibilityAreaRepository.VA.name, (Object)name)).executeWithKey(VisibilityAreaRepository.VA.id)), (Object)"nothing created");
        return this.visibilityAreaProjection.create(vaId, name);
    }

    @Nonnull
    public VisibilityArea create(@Nonnull UUID id, @Nonnull String name) {
        VisibilityArea visibilityArea = this.create(name);
        ((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)VA).where((Predicate)VisibilityAreaRepository.VA.id.eq((Object)visibilityArea.getId()))).set(VisibilityAreaRepository.VA.id, (Object)id)).execute();
        visibilityArea.setId(id);
        return visibilityArea;
    }

    @Nullable
    public VisibilityArea getById(@Nonnull UUID id) {
        return this.cacheRepo.tryComputeIfAbsent(VisibilityArea.class, id, uuid -> (VisibilityArea)this.select((Predicate)VisibilityAreaRepository.VA.id.eq(uuid)).fetchOne());
    }

    public boolean existsById(UUID id) {
        return this.cacheRepo.getIfPresent(VisibilityArea.class, id) != null || this.select((Predicate)VisibilityAreaRepository.VA.id.eq((Object)id)).fetchCount() > 0L;
    }

    @Nonnull
    protected SQLQuery<VisibilityArea> select(@Nonnull Predicate predicate) {
        return (SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.visibilityAreaProjection).from((Expression)VA)).where(predicate);
    }

    @Nonnull
    public List<VisibilityArea> getAll() {
        return ((SQLQuery)this.queryFactory.select((Expression)this.visibilityAreaProjection).from((Expression)VA)).fetch();
    }

    @Nonnull
    public List<VisibilityArea> getAllSorted() {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.visibilityAreaProjection).from((Expression)VA)).orderBy(VisibilityAreaRepository.VA.name.asc())).fetch();
    }

    public boolean rename(@Nonnull UUID id, @Nonnull String name) {
        return ((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)VA).where((Predicate)VisibilityAreaRepository.VA.id.eq((Object)id))).set((Path)VisibilityAreaRepository.VA.name, (Object)name)).execute() > 1L;
    }

    public boolean delete(@Nonnull UUID id) {
        ((DataSetListRepository)this.dslRepo.get()).onVaDeleteCascade(id);
        ((TestPlanRepository)this.testPlanRepo.get()).onVaDeleteCascade(id);
        ((FilterRepository)this.filtersRepo.get()).onVaDeleteCascade(id);
        return this.delete((Predicate)VisibilityAreaRepository.VA.id.eq((Object)id)) > 0L;
    }

    private long delete(@Nonnull Predicate predicate) {
        return ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)VA).where(predicate)).execute();
    }

    private static class VisibilityAreaProjection
    extends MappingProjection<VisibilityArea> {
        private final VisibilityAreaRepository repo;

        VisibilityAreaProjection(VisibilityAreaRepository repo) {
            super(VisibilityArea.class, (Expression[])AbstractRepository.VA.all());
            this.repo = repo;
        }

        protected VisibilityAreaImpl map(Tuple row) {
            UUID id = (UUID)row.get(AbstractRepository.VA.id);
            assert (id != null);
            String name = (String)row.get((Expression)AbstractRepository.VA.name);
            assert (name != null);
            return this.create(id, name);
        }

        private VisibilityAreaImpl create(@Nonnull UUID id, @Nonnull String name) {
            List<DataSetList> dataSetLists = Proxies.list(() -> ((DataSetListRepository)this.repo.dslRepo.get()).getAll(id));
            return new VisibilityAreaImpl(id, name, dataSetLists);
        }
    }
}

