/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db.jpa.entities;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.qubership.atp.dataset.model.AttributeType;

public enum AttributesSortType {
    UNSORTED(0),
    SORT_BY_NAME(1);

    private static final Map<Short, AttributesSortType> shortMapping;
    private final short id;

    private AttributesSortType(short id) {
        this.id = id;
    }

    @Nonnull
    public static AttributesSortType from(short id) {
        return shortMapping.computeIfAbsent(id, someId -> Arrays.stream(AttributesSortType.values()).filter(type -> someId.equals(type.getId())).findFirst().orElseThrow(() -> new IllegalStateException("Illegal sort type specified. Expected: " + Arrays.toString((Object[])AttributeType.values()))));
    }

    public short getId() {
        return this.id;
    }

    public String getName() {
        return this.name();
    }

    static {
        shortMapping = new HashMap<Short, AttributesSortType>();
    }
}

