/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db.jpa.entities;

import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.qubership.atp.dataset.db.jpa.entities.AbstractUuidBasedEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetListEntity;
import org.qubership.atp.dataset.db.jpa.entities.LabelEntity;
import org.qubership.atp.dataset.db.jpa.entities.ParameterEntity;

@Entity
@Table(name="dataset")
public class DataSetEntity
extends AbstractUuidBasedEntity {
    private static final long serialVersionUID = 137890563796237611L;
    @Column(name="name")
    private String name;
    @Column(name="ordering", nullable=false)
    private Long ordering;
    @Column(name="source_id")
    private UUID sourceId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="datasetlist_id")
    private DataSetListEntity dataSetList;
    @OneToMany(mappedBy="dataSet", fetch=FetchType.LAZY)
    private List<ParameterEntity> parameters = new LinkedList<ParameterEntity>();
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="dataset_label", joinColumns={@JoinColumn(name="dataset_id")}, inverseJoinColumns={@JoinColumn(name="label_id")})
    private List<LabelEntity> labels = new LinkedList<LabelEntity>();
    @Column(name="locked", nullable=false, columnDefinition="boolean DEFAULT false")
    private boolean locked;

    public void setName(String name) {
        this.name = name;
    }

    public void setOrdering(Long ordering) {
        this.ordering = ordering;
    }

    public void setSourceId(UUID sourceId) {
        this.sourceId = sourceId;
    }

    public void setDataSetList(DataSetListEntity dataSetList) {
        this.dataSetList = dataSetList;
    }

    public void setParameters(List<ParameterEntity> parameters) {
        this.parameters = parameters;
    }

    public void setLabels(List<LabelEntity> labels) {
        this.labels = labels;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public String getName() {
        return this.name;
    }

    public Long getOrdering() {
        return this.ordering;
    }

    public UUID getSourceId() {
        return this.sourceId;
    }

    public DataSetListEntity getDataSetList() {
        return this.dataSetList;
    }

    public List<ParameterEntity> getParameters() {
        return this.parameters;
    }

    public List<LabelEntity> getLabels() {
        return this.labels;
    }

    public boolean isLocked() {
        return this.locked;
    }
}

