/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db.jpa.entities;

import java.sql.Timestamp;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import org.qubership.atp.dataset.db.jpa.entities.AbstractUuidBasedEntity;
import org.qubership.atp.dataset.db.jpa.entities.AttributeEntity;
import org.qubership.atp.dataset.db.jpa.entities.AttributeKeyEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetEntity;
import org.qubership.atp.dataset.db.jpa.entities.LabelEntity;
import org.qubership.atp.dataset.db.jpa.entities.TestPlanEntity;
import org.qubership.atp.dataset.db.jpa.entities.VisibilityAreaEntity;

@Entity
@Table(name="datasetlist")
public class DataSetListEntity
extends AbstractUuidBasedEntity {
    private static final long serialVersionUID = 1558849568530137446L;
    @Column(name="name")
    private String name;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="visibility_area_id")
    private VisibilityAreaEntity visibilityArea;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="test_plan_id")
    private TestPlanEntity testPlan;
    @Column(name="source_id")
    private UUID sourceId;
    @OneToMany(mappedBy="dataSetList", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true)
    private Set<AttributeKeyEntity> attributeKeys = new HashSet<AttributeKeyEntity>();
    @OrderBy(value="ordering ASC")
    @OneToMany(mappedBy="dataSetList", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true)
    private List<AttributeEntity> attributes = new LinkedList<AttributeEntity>();
    @OrderBy(value="ordering ASC")
    @OneToMany(mappedBy="dataSetList", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true)
    private List<DataSetEntity> dataSets = new LinkedList<DataSetEntity>();
    @Column(name="created_by")
    private UUID createdBy;
    @Column(name="created_when")
    private Timestamp createdWhen;
    @Column(name="modified_by")
    private UUID modifiedBy;
    @Column(name="modified_when")
    private Timestamp modifiedWhen;
    @ManyToMany
    @JoinTable(name="datasetlist_label", joinColumns={@JoinColumn(name="datasetlist_id")}, inverseJoinColumns={@JoinColumn(name="label_id")})
    private List<LabelEntity> labels = new LinkedList<LabelEntity>();
    @Column(name="saga_session_id")
    private UUID sagaSessionId;

    public void setName(String name) {
        this.name = name;
    }

    public void setVisibilityArea(VisibilityAreaEntity visibilityArea) {
        this.visibilityArea = visibilityArea;
    }

    public void setTestPlan(TestPlanEntity testPlan) {
        this.testPlan = testPlan;
    }

    public void setSourceId(UUID sourceId) {
        this.sourceId = sourceId;
    }

    public void setAttributeKeys(Set<AttributeKeyEntity> attributeKeys) {
        this.attributeKeys = attributeKeys;
    }

    public void setAttributes(List<AttributeEntity> attributes) {
        this.attributes = attributes;
    }

    public void setDataSets(List<DataSetEntity> dataSets) {
        this.dataSets = dataSets;
    }

    public void setCreatedBy(UUID createdBy) {
        this.createdBy = createdBy;
    }

    public void setCreatedWhen(Timestamp createdWhen) {
        this.createdWhen = createdWhen;
    }

    public void setModifiedBy(UUID modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public void setModifiedWhen(Timestamp modifiedWhen) {
        this.modifiedWhen = modifiedWhen;
    }

    public void setLabels(List<LabelEntity> labels) {
        this.labels = labels;
    }

    public void setSagaSessionId(UUID sagaSessionId) {
        this.sagaSessionId = sagaSessionId;
    }

    public String getName() {
        return this.name;
    }

    public VisibilityAreaEntity getVisibilityArea() {
        return this.visibilityArea;
    }

    public TestPlanEntity getTestPlan() {
        return this.testPlan;
    }

    public UUID getSourceId() {
        return this.sourceId;
    }

    public Set<AttributeKeyEntity> getAttributeKeys() {
        return this.attributeKeys;
    }

    public List<AttributeEntity> getAttributes() {
        return this.attributes;
    }

    public List<DataSetEntity> getDataSets() {
        return this.dataSets;
    }

    public UUID getCreatedBy() {
        return this.createdBy;
    }

    public Timestamp getCreatedWhen() {
        return this.createdWhen;
    }

    public UUID getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModifiedWhen() {
        return this.modifiedWhen;
    }

    public List<LabelEntity> getLabels() {
        return this.labels;
    }

    public UUID getSagaSessionId() {
        return this.sagaSessionId;
    }
}

