/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ei.service;

import clover.com.google.common.collect.Lists;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.qubership.atp.dataset.ei.model.AttributeKeyIdsDbUpdate;
import org.qubership.atp.dataset.ei.model.DataSetAttribute;
import org.qubership.atp.dataset.ei.model.DataSetAttributeKey;
import org.qubership.atp.dataset.ei.model.DataSetList;
import org.qubership.atp.dataset.ei.model.DataSetListValue;
import org.qubership.atp.dataset.ei.service.DuplicateNameChecker;
import org.qubership.atp.dataset.ei.service.EntityManagerController;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.JpaAttributeService;
import org.qubership.atp.dataset.service.jpa.JpaDataSetListService;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.dataset.service.jpa.delegates.ListValue;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.exceptions.ExportException;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DataSetAttributesImporter {
    private static final Logger log = LoggerFactory.getLogger(DataSetAttributesImporter.class);
    private final ObjectLoaderFromDiskService objectLoaderFromDiskService;
    private final JpaAttributeService attrService;
    private final JpaDataSetListService dslService;
    private final DuplicateNameChecker duplicateNameChecker;
    private final EntityManagerController entityManagerController;

    public void importDataSetAttributes(Path workDir, List<UUID> dataSetLists, ExportImportData importData) {
        log.info("start importDataSetAttributes(workDir: {}, dataSetLists: {})", (Object)workDir, dataSetLists);
        Map list = this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetAttribute.class);
        log.debug("importDataSetAttributes list: {}", (Object)list);
        ArrayList createdAttributes = new ArrayList();
        for (List chunk : Lists.partition(new ArrayList(list.keySet()), (int)1000)) {
            chunk.forEach(id -> this.importDataSetAttributes((UUID)id, (Path)list.get(id), dataSetLists, createdAttributes, importData));
            this.entityManagerController.flushAndClear();
            log.info("Chunk with size {} completed. Total size {}.", (Object)chunk.size(), (Object)list.size());
        }
        Map listValues = this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetListValue.class);
        for (List chunk : Lists.partition(new ArrayList(listValues.keySet()), (int)1000)) {
            chunk.forEach(id -> this.importDataSetListValues((UUID)id, (Path)listValues.get(id), createdAttributes, importData));
            this.entityManagerController.flushAndClear();
            log.info("Chunk with size {} completed. Total size {}.", (Object)chunk.size(), (Object)list.size());
        }
        log.info("end importDataSetAttributes()");
    }

    private void importDataSetAttributes(UUID id, Path path, List<UUID> dataSetLists, List<UUID> createdAttributes, ExportImportData importData) {
        DataSetAttribute object;
        log.debug("importDataSetAttributes start import id: {}", (Object)id);
        if (importData.isCreateNewProject() || importData.isInterProjectImport()) {
            HashMap map = new HashMap(importData.getReplacementMap());
            object = (DataSetAttribute)this.objectLoaderFromDiskService.loadFileAsObjectWithReplacementMap(path, DataSetAttribute.class, map);
        } else {
            object = (DataSetAttribute)this.objectLoaderFromDiskService.loadFileAsObject(path, DataSetAttribute.class);
        }
        log.debug("importDataSetAttributes import object: {}", (Object)object);
        if (object == null) {
            String message = String.format("Cannot load file by path %s", path.toString());
            log.error(message);
            throw new RuntimeException(message);
        }
        if (!dataSetLists.contains(object.getDataSetList())) {
            return;
        }
        if (object.getTypeDataSetList() != null) {
            org.qubership.atp.dataset.service.jpa.delegates.DataSetList dataSetList = this.dslService.getById(object.getTypeDataSetList());
            log.debug("dataSetList: {}", (Object)dataSetList);
            if (dataSetList == null && !dataSetLists.contains(object.getTypeDataSetList())) {
                return;
            }
        }
        AttributeTypeName type = AttributeTypeName.getTypeById(object.getAttributeType());
        Attribute attribute = this.attrService.getById(object.getId());
        if (attribute == null) {
            object.setSourceId(id);
            this.createWithCheckName(object, type);
        } else {
            this.updateWithCheckName(attribute, object, type);
        }
        this.duplicateNameChecker.addToCache(object.getDataSetList(), object);
        createdAttributes.add(object.getId());
    }

    private void importDataSetListValues(UUID id, Path path, List<UUID> createdAttributes, ExportImportData importData) {
        DataSetListValue object;
        if (importData.isCreateNewProject() || importData.isInterProjectImport()) {
            HashMap map = new HashMap(importData.getReplacementMap());
            object = (DataSetListValue)this.objectLoaderFromDiskService.loadFileAsObjectWithReplacementMap(path, DataSetListValue.class, map);
        } else {
            object = (DataSetListValue)this.objectLoaderFromDiskService.loadFileAsObject(path, DataSetListValue.class);
        }
        log.debug("import object: {}", (Object)object);
        if (object == null) {
            String message = String.format("Cannot load file by path %s", path.toString());
            log.error(message);
            throw new RuntimeException(message);
        }
        if (!createdAttributes.contains(object.getAttribute())) {
            return;
        }
        ListValue listValue = this.attrService.getListValueById(object.getId());
        if (listValue == null) {
            object.setSourceId(id);
            try {
                this.attrService.replicateListValue(object.getId(), object.getText(), object.getAttribute(), object.getSourceId());
            }
            catch (DataSetServiceException e) {
                String message = String.format("Cannot create list value by import object %s", object);
                log.error(message);
                throw new ExportException(message, (Throwable)e);
            }
        } else {
            listValue.setText(object.getText());
            listValue.setAttribute(object.getAttribute());
            this.attrService.save(listValue);
        }
    }

    private void updateWithCheckName(Attribute attribute, DataSetAttribute object, AttributeTypeName type) {
        this.checkAndCorrectName(object);
        attribute.setName(object.getName());
        attribute.setAttributeType(type);
        attribute.setDataSetList(object.getDataSetList());
        attribute.setTypeDataSetListId(object.getTypeDataSetList());
        this.attrService.save(attribute);
    }

    private void createWithCheckName(DataSetAttribute object, AttributeTypeName type) {
        this.checkAndCorrectName(object);
        try {
            Attribute attribute = this.attrService.replicate(object.getId(), object.getName(), type, object.getDataSetList(), object.getSourceId());
            attribute.setTypeDataSetListId(object.getTypeDataSetList());
            this.attrService.save(attribute);
        }
        catch (DataSetServiceException e) {
            String message = String.format("Cannot create new attribute by import object %s", object);
            log.error(message);
            throw new ExportException(message, (Throwable)e);
        }
    }

    public void checkAndCorrectName(DataSetAttribute object) {
        this.initCache(object.getDataSetList());
        this.duplicateNameChecker.checkAndCorrectName(object.getDataSetList(), object);
    }

    private boolean isNameUsed(DataSetAttribute object, UUID dsListId) {
        this.initCache(dsListId);
        return this.duplicateNameChecker.isNameUsed(dsListId, object);
    }

    private void initCache(UUID dsListId) {
        if (!this.duplicateNameChecker.isInitialized(DataSetAttribute.class, dsListId)) {
            HashMultimap initMap = HashMultimap.create();
            this.attrService.getByDataSetListId(dsListId).forEach(arg_0 -> DataSetAttributesImporter.lambda$initCache$2((Multimap)initMap, arg_0));
            this.duplicateNameChecker.init(DataSetAttribute.class, dsListId, (Multimap<String, UUID>)initMap);
        }
    }

    public void importDataSetAttributeKeys(Path workDir, ExportImportData importData) throws IOException {
        log.info("start importDataSetAttributeKeys(workDir: {})", (Object)workDir);
        Map list = this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetAttributeKey.class);
        log.debug("importDataSetAttributeKeys list: {}", (Object)list);
        for (List chunk : Lists.partition(new ArrayList(list.keySet()), (int)1000)) {
            chunk.forEach(id -> this.importDataSetAttributeKeys((UUID)id, (Path)list.get(id), importData));
            this.entityManagerController.flushAndClear();
            log.debug("Chunk with size {} completed. Total size {}.", (Object)chunk.size(), (Object)list.size());
        }
        log.info("end importDataSetAttributeKeys()");
    }

    private void importDataSetAttributeKeys(UUID id, Path path, ExportImportData importData) {
        DataSetAttributeKey object;
        log.debug("importDataSetAttributeKeys start import id: {}", (Object)id);
        if (importData.isCreateNewProject() || importData.isInterProjectImport()) {
            HashMap<UUID, UUID> map = new HashMap<UUID, UUID>(importData.getReplacementMap());
            object = (DataSetAttributeKey)this.objectLoaderFromDiskService.loadFileAsObjectWithReplacementMap(path, DataSetAttributeKey.class, map);
            object.setKey(this.getKeyWithReplacement(object, map));
        } else {
            object = (DataSetAttributeKey)this.objectLoaderFromDiskService.loadFileAsObject(path, DataSetAttributeKey.class);
        }
        log.debug("import object: {}", (Object)object);
        if (object == null) {
            String message = String.format("Cannot load file by path %s", path.toString());
            log.error(message);
            throw new RuntimeException(message);
        }
        Attribute attribute = this.attrService.getById(object.getAttribute());
        log.debug("attribute: {}", (Object)attribute);
        if (attribute == null) {
            return;
        }
        AttributeKey attrKey = this.getAttributeKey(object);
        if (attrKey == null) {
            object.setSourceId(id);
            try {
                this.attrService.replicateAttributeKey(object.getId(), object.getKey(), object.getAttribute(), object.getDataSet(), object.getDataSetList(), object.getSourceId());
            }
            catch (DataSetServiceException e) {
                String message = String.format("Cannot create new attribute key by import object %s", object);
                log.error(message);
                throw new ExportException(message, (Throwable)e);
            }
        } else {
            attrKey.setKey(object.getKey());
            attrKey.setAttribute(object.getAttribute());
            attrKey.setDataSet(object.getDataSet());
            attrKey.setDataSetList(object.getDataSetList());
            this.attrService.save(attrKey);
        }
    }

    private AttributeKey getAttributeKey(DataSetAttributeKey object) {
        AttributeKey attrKey = this.attrService.getAttributeKeyById(object.getId());
        if (Objects.isNull(attrKey) && Objects.nonNull(attrKey = this.attrService.getAttributeKeyByKeyAndDataSetListIdAndDataSetIdAndAttributeId(object.getKey(), object.getDataSetList(), object.getDataSet(), object.getAttribute()))) {
            this.attrService.getFoundedAttributeKeyIdAndDatasetIdUpdate().put(object.getId(), new AttributeKeyIdsDbUpdate(attrKey.getId(), attrKey.getDataSetId()));
        }
        return attrKey;
    }

    private String getKeyWithReplacement(DataSetAttributeKey object, Map<UUID, UUID> replacementMap) {
        String[] splitResult;
        ArrayList<UUID> keyIds = new ArrayList<UUID>();
        for (String splitPart : splitResult = object.getKey().split("_")) {
            keyIds.add(replacementMap.get(UUID.fromString(splitPart)));
        }
        return StringUtils.join(keyIds, (String)"_");
    }

    public List<UUID> getDsAttributeIds(Path workDir) {
        return new ArrayList<UUID>(this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetAttribute.class).keySet());
    }

    public List<UUID> getDsAttributeKeysIds(Path workDir) {
        return new ArrayList<UUID>(this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetAttributeKey.class).keySet());
    }

    public List<UUID> getDsListValuesIds(Path workDir) {
        return new ArrayList<UUID>(this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetListValue.class).keySet());
    }

    public List<String> validateDataSetAttributes(Path workDir, Map<UUID, UUID> repMap, boolean isInterProjectImport) {
        log.info("start validateDataSetAttributes(workDir: {})", (Object)workDir);
        HashSet result = new HashSet();
        Map dataSetLists = this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetList.class);
        Set dslIdsWithReplacement = isInterProjectImport ? dataSetLists.keySet().stream().map(repMap::get).collect(Collectors.toSet()) : dataSetLists.keySet();
        Map dataSetAttributes = this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetAttribute.class);
        for (List chunk : Lists.partition(new ArrayList(dataSetAttributes.keySet()), (int)1000)) {
            chunk.forEach(id -> {
                try {
                    this.validateDataSetAttributes((UUID)id, (Path)dataSetAttributes.get(id), dslIdsWithReplacement, repMap, isInterProjectImport, result);
                }
                catch (RuntimeException e) {
                    log.error("Cannot import attribute {}", id, (Object)e);
                    throw e;
                }
            });
        }
        Map dataSetAttributeKeys = this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetAttributeKey.class);
        for (List chunk : Lists.partition(new ArrayList(dataSetAttributeKeys.keySet()), (int)1000)) {
            chunk.forEach(id -> {
                try {
                    this.validateDataSetAttributeKeys((UUID)id, (Path)dataSetAttributeKeys.get(id), dataSetAttributes, repMap, isInterProjectImport, result);
                }
                catch (RuntimeException e) {
                    log.error("Cannot import attribute key {}", id, (Object)e);
                    throw e;
                }
            });
        }
        log.info("end validateDataSetAttributes(result: {})", result);
        return new ArrayList<String>(result);
    }

    private void validateDataSetAttributes(UUID id, Path path, Set<UUID> dataSetLists, Map<UUID, UUID> repMap, boolean isInterProjectImport, Set<String> result) {
        org.qubership.atp.dataset.service.jpa.delegates.DataSetList dataSetList;
        log.debug("dataSetAttributes start validate id: {}", (Object)id);
        DataSetAttribute object = isInterProjectImport ? (DataSetAttribute)this.objectLoaderFromDiskService.loadFileAsObjectWithReplacementMap(path, DataSetAttribute.class, repMap) : (DataSetAttribute)this.objectLoaderFromDiskService.loadFileAsObject(path, DataSetAttribute.class);
        log.debug("dataSetAttributes validate object: {}", (Object)object);
        if (object == null) {
            log.error("Cannot load file by path {}", (Object)path.toString());
            result.add("Some file cannot be loaded from import archive.");
            return;
        }
        if (this.isNameUsed(object, object.getDataSetList())) {
            dataSetList = this.dslService.getById(object.getDataSetList());
            result.add(String.format("Attribute with name '%s' already exists in Data Set List '%s'. Imported one will be renamed to '%s Copy'.", object.getName(), dataSetList.getName(), object.getName()));
        }
        if (object.getTypeDataSetList() != null) {
            dataSetList = this.dslService.getById(object.getTypeDataSetList());
            log.debug("dataSetList: {}", (Object)dataSetList);
            if (dataSetList == null && !dataSetLists.contains(object.getTypeDataSetList())) {
                log.error("Attribute {} has link to data set list {}, but this data set list is absent in server and is not being imported", (Object)object, (Object)object.getTypeDataSetList());
                result.add(String.format("There is an attribute that has the link to data set list %s, but this data set list is absent in server and is not being imported.", object.getName()));
            }
        }
    }

    private void validateDataSetAttributeKeys(UUID id, Path path, Map<UUID, Path> dataSetAttributes, Map<UUID, UUID> repMap, boolean isInterProjectImport, Set<String> result) {
        UUID attributeIdWithoutReplacement;
        DataSetAttributeKey object;
        log.debug("dataSetAttributeKeys start validate id: {}", (Object)id);
        if (isInterProjectImport) {
            object = (DataSetAttributeKey)this.objectLoaderFromDiskService.loadFileAsObjectWithReplacementMap(path, DataSetAttributeKey.class, repMap);
            DataSetAttributeKey objectWithoutReplacementMap = (DataSetAttributeKey)this.objectLoaderFromDiskService.loadFileAsObject(path, DataSetAttributeKey.class);
            attributeIdWithoutReplacement = objectWithoutReplacementMap.getAttribute();
        } else {
            object = (DataSetAttributeKey)this.objectLoaderFromDiskService.loadFileAsObject(path, DataSetAttributeKey.class);
            attributeIdWithoutReplacement = object.getAttribute();
        }
        log.debug("dataSetAttributeKeys validate object: {}", (Object)object);
        if (object == null) {
            log.error("Cannot load file by path {}", (Object)path.toString());
            result.add("Some file cannot be loaded from import archive.");
            return;
        }
        Attribute attribute = this.attrService.getById(object.getAttribute());
        log.debug("attribute: {}", (Object)attribute);
        if (attribute == null) {
            DataSetAttribute linkToDsAttribute = (DataSetAttribute)this.objectLoaderFromDiskService.loadFileAsObject(dataSetAttributes.get(attributeIdWithoutReplacement), DataSetAttribute.class);
            if (linkToDsAttribute == null) {
                log.error("Cannot load file by path {}", (Object)path.toString());
                result.add("Some file cannot be loaded from import archive.");
                return;
            }
            DataSetAttribute absentAttribute = (DataSetAttribute)this.objectLoaderFromDiskService.loadFileAsObject(dataSetAttributes.get(attributeIdWithoutReplacement), DataSetAttribute.class);
            if (absentAttribute == null) {
                log.error("Attribute key (Link to Data Set Attribute) {} refers to absent attribute {}", (Object)object, (Object)object.getAttribute());
                result.add(String.format("There is a Link to Data Set Attribute that refers to absent attribute on server.", new Object[0]));
            }
        }
    }

    public void fillRepMapWithSourceTargetValues(Map<UUID, UUID> replacementMap, Path workDir) {
        this.fillAttributesSourceTargetMap(replacementMap, workDir);
        this.fillAttrKeysSourceTargetMap(replacementMap, workDir);
        this.fillListValuesSourceTargetMap(replacementMap, workDir);
    }

    private void fillAttributesSourceTargetMap(Map<UUID, UUID> replacementMap, Path workDir) {
        Map objectsToImport = this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetAttribute.class);
        for (List chunk : Lists.partition(new ArrayList(objectsToImport.keySet()), (int)1000)) {
            chunk.forEach(id -> {
                if (!replacementMap.containsKey(id)) {
                    DataSetAttribute object = (DataSetAttribute)this.objectLoaderFromDiskService.loadFileAsObject((Path)objectsToImport.get(id), DataSetAttribute.class);
                    List<Attribute> existingObject = this.attrService.getBySourceIdAndDataSetListId((UUID)id, (UUID)replacementMap.get(object.getDataSetList()));
                    if (CollectionUtils.isEmpty(existingObject)) {
                        replacementMap.put((UUID)id, (UUID)null);
                    } else {
                        replacementMap.put((UUID)id, existingObject.get(0).getId());
                    }
                }
            });
        }
    }

    private void fillAttrKeysSourceTargetMap(Map<UUID, UUID> replacementMap, Path workDir) {
        Map objectsToImport = this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetAttributeKey.class);
        for (List chunk : Lists.partition(new ArrayList(objectsToImport.keySet()), (int)1000)) {
            chunk.forEach(id -> {
                if (!replacementMap.containsKey(id)) {
                    DataSetAttributeKey object = (DataSetAttributeKey)this.objectLoaderFromDiskService.loadFileAsObject((Path)objectsToImport.get(id), DataSetAttributeKey.class);
                    List<AttributeKey> existingObject = this.attrService.getAttrKeyBySourceIdAndDataSetListId((UUID)id, (UUID)replacementMap.get(object.getDataSetList()));
                    if (CollectionUtils.isEmpty(existingObject)) {
                        replacementMap.put((UUID)id, (UUID)null);
                    } else {
                        replacementMap.put((UUID)id, existingObject.get(0).getId());
                    }
                }
            });
        }
    }

    private void fillListValuesSourceTargetMap(Map<UUID, UUID> replacementMap, Path workDir) {
        Map objectsToImport = this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetListValue.class);
        for (List chunk : Lists.partition(new ArrayList(objectsToImport.keySet()), (int)1000)) {
            chunk.forEach(id -> {
                if (!replacementMap.containsKey(id)) {
                    DataSetListValue object = (DataSetListValue)this.objectLoaderFromDiskService.loadFileAsObject((Path)objectsToImport.get(id), DataSetListValue.class);
                    List<ListValue> existingObject = this.attrService.getListValueBySourceIdAndAttrId((UUID)id, (UUID)replacementMap.get(object.getAttribute()));
                    if (CollectionUtils.isEmpty(existingObject)) {
                        replacementMap.put((UUID)id, (UUID)null);
                    } else {
                        replacementMap.put((UUID)id, existingObject.get(0).getId());
                    }
                }
            });
        }
    }

    public DataSetAttributesImporter(ObjectLoaderFromDiskService objectLoaderFromDiskService, JpaAttributeService attrService, JpaDataSetListService dslService, DuplicateNameChecker duplicateNameChecker, EntityManagerController entityManagerController) {
        this.objectLoaderFromDiskService = objectLoaderFromDiskService;
        this.attrService = attrService;
        this.dslService = dslService;
        this.duplicateNameChecker = duplicateNameChecker;
        this.entityManagerController = entityManagerController;
    }

    private static /* synthetic */ void lambda$initCache$2(Multimap initMap, Attribute entity) {
        initMap.put((Object)entity.getName(), (Object)entity.getId());
    }
}

