/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.kafka.handlers.project.strategies;

import org.qubership.atp.dataset.kafka.entities.project.EventType;
import org.qubership.atp.dataset.kafka.entities.project.ProjectEvent;
import org.qubership.atp.dataset.kafka.handlers.project.ProcessingStrategy;
import org.qubership.atp.dataset.service.direct.VisibilityAreaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"kafka.enable"}, matchIfMissing=false)
public class CreateProjectProcessingStrategy
implements ProcessingStrategy<ProjectEvent, EventType> {
    @Autowired
    private VisibilityAreaService visibilityAreaService;

    @Override
    public void process(ProjectEvent projectEvent) {
        this.visibilityAreaService.create(projectEvent.getProjectId(), projectEvent.getProjectName());
    }

    @Override
    public EventType getIdentifier() {
        return EventType.CREATE;
    }
}

