/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.exception;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.macros.EvaluationContext;
import org.qubership.atp.dataset.macros.exception.EvalException;
import org.qubership.atp.dataset.macros.processor.MacroContextBase;

public class CtxEvalException
extends EvalException {
    private final String source;
    private final Object ctx;

    public CtxEvalException(@Nonnull String message, @Nonnull MacroContextBase ctx, @Nullable Throwable cause) {
        super(message, cause);
        this.ctx = ctx;
        this.source = ctx.toString();
    }

    public CtxEvalException(@Nonnull String message, @Nonnull EvaluationContext ctx) {
        this(message, ctx, null);
    }

    public CtxEvalException(@Nonnull String message, @Nonnull EvaluationContext ctx, @Nullable Throwable cause) {
        super(message, cause);
        this.ctx = ctx;
        ArrayList<EvaluationContext> fromParent = new ArrayList<EvaluationContext>();
        for (EvaluationContext current = ctx; current != null; current = current.getParent()) {
            fromParent.add(current);
        }
        this.source = Lists.reverse(fromParent).stream().map(Object::toString).collect(Collectors.joining("<into>"));
    }

    public CtxEvalException(@Nonnull String message, @Nonnull MacroContextBase ctx) {
        this(message, ctx, null);
    }

    @Nonnull
    public String getSource() {
        return this.source;
    }

    @Override
    public String toString() {
        return "Problem here: " + this.ctx + "\n" + super.toString();
    }
}

