/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.impl;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.stream.Stream;
import org.qubership.atp.dataset.macros.EvaluationContext;
import org.qubership.atp.dataset.macros.Macros;
import org.qubership.atp.dataset.macros.args.ArgsParser;
import org.qubership.atp.dataset.macros.args.DumbArgsParser;
import org.qubership.atp.dataset.macros.args.MacroArg;
import org.springframework.stereotype.Component;

@Component
public class SumMacros
extends Macros<Integer> {
    public SumMacros() {
        super("SUM");
    }

    @Override
    public Integer evaluate(Stream<? extends MacroArg> input, EvaluationContext context) throws Exception {
        String text = input.findAny().orElseThrow(() -> new IllegalArgumentException("One argument expected")).getText();
        List strings = Splitter.on((char)',').trimResults().splitToList((CharSequence)text);
        if (strings.size() != 2) {
            throw new IllegalArgumentException("Invalid input data. Data must matches to (numeric,numeric). Data: " + input);
        }
        return Integer.parseInt((String)strings.get(0)) + Integer.parseInt((String)strings.get(1));
    }

    @Override
    public ArgsParser createArgsParser() {
        return new DumbArgsParser();
    }

    @Override
    public boolean doCache() {
        return true;
    }

    public String toString() {
        return "sum";
    }
}

