/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.processor;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.macros.EvaluationContext;
import org.qubership.atp.dataset.macros.MacroRegistry;
import org.qubership.atp.dataset.macros.Macros;
import org.qubership.atp.dataset.macros.args.ArgsParser;
import org.qubership.atp.dataset.macros.args.RefArg;
import org.qubership.atp.dataset.macros.args.SignatureArg;
import org.qubership.atp.dataset.macros.exception.CtxEvalException;
import org.qubership.atp.dataset.macros.parser.TokenType;
import org.qubership.atp.dataset.macros.processor.MacroContextBase;
import org.qubership.atp.dataset.macros.processor.MacroProcessorBase;
import org.qubership.atp.dataset.macros.processor.MacroProcessorImpl;
import org.qubership.atp.dataset.service.direct.AliasWrapperService;
import org.qubership.atp.dataset.service.direct.UnwrapStatus;

public final class MacroContext
extends MacroContextBase {
    protected final AliasWrapperService wrapperService;
    private final EvaluationContext parent;
    private final MacroProcessorImpl processor;
    private final MacroRegistry registry;
    private final EvaluationContext evaluationContext;
    protected boolean doCache = true;
    protected Macros macros;
    protected ArgsParser args;
    protected StringBuilder text = new StringBuilder();
    private int wrappedArgs;

    public MacroContext(@Nonnull AliasWrapperService wrapperService, @Nullable EvaluationContext parent, @Nonnull MacroProcessorImpl processor, @Nonnull MacroRegistry registry, EvaluationContext evaluationContext) {
        this.wrapperService = wrapperService;
        this.parent = parent;
        this.processor = processor;
        this.registry = registry;
        this.evaluationContext = evaluationContext;
        this.wrappedArgs = -1;
    }

    public MacroContext(@Nonnull MacroContext parent, @Nonnull String macro) {
        super(parent, macro);
        this.wrapperService = parent.wrapperService;
        this.parent = parent.parent;
        this.processor = parent.processor;
        this.registry = parent.registry;
        this.evaluationContext = parent.evaluationContext;
        this.wrappedArgs = -1;
        this.doCache = parent.doCache;
        this.initialize(macro);
        parent.wrappedArgs = 0;
    }

    @Override
    public void initialize(@Nonnull String macro) {
        super.initialize(macro);
        this.macros = this.registry.getMacros(macro);
        this.args = this.macros.createArgsParser();
    }

    @Override
    protected void pushArguments(@Nonnull String args) {
        this.args.append(args);
    }

    @Override
    protected void pushText(@Nonnull String text) {
        this.text.append(text);
    }

    @Override
    @Nonnull
    public MacroProcessorImpl getProcessor() {
        return this.processor;
    }

    @Override
    protected void evaluate() throws CtxEvalException {
        Object evaluate;
        assert (this.macros != null);
        assert (this.args != null);
        ArgsParser.Result result = this.args.parseToTheEnd();
        Optional<Exception> error = result.getError();
        if (error.isPresent()) {
            throw new CtxEvalException("Can not parse args: " + this.args, this.evaluationContext, (Throwable)error.get());
        }
        Optional<String> unparsed = result.getUnparsed();
        if (unparsed.isPresent()) {
            throw new CtxEvalException("Macro arguments not fully parsed: " + unparsed.get(), this);
        }
        try {
            this.unwrapAliases(result);
        }
        catch (Exception e) {
            throw new CtxEvalException("Can not unwrap aliases: " + result, this.evaluationContext, (Throwable)e);
        }
        try {
            evaluate = this.macros.evaluate(result.getParsed().stream(), this.evaluationContext);
        }
        catch (CtxEvalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CtxEvalException("Can not evaluate macro [" + this.macros + "] with params [" + result.getParsed() + "]", this.evaluationContext, (Throwable)e);
        }
        this.text.append(Optional.ofNullable(evaluate).map(Objects::toString).orElse(""));
    }

    private void unwrapAliases(ArgsParser.Result result) {
        List<SignatureArg> parsed = result.getParsed();
        int wrappedArgs = this.wrappedArgs == -1 ? parsed.size() : this.wrappedArgs;
        Iterator<SignatureArg> iterator = parsed.iterator();
        block3: for (int i = 0; i < wrappedArgs; ++i) {
            Optional<RefArg.Signature<?>> signature = iterator.next().asRef();
            if (!signature.isPresent()) continue;
            RefArg.Signature<?> arg = signature.get();
            UnwrapStatus unwrapStatus = this.wrapperService.unWrapAlias(arg);
            switch (unwrapStatus) {
                case UNUSED: {
                    iterator.remove();
                    continue block3;
                }
            }
        }
    }

    protected void beforeReevaluation() {
        this.wrappedArgs = this.args.tryParse().getParsed().size();
        this.args.clear();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.strategy == MacroProcessorBase.START) {
            result.append((CharSequence)this.text);
        }
        if (this.macros != null) {
            result.append(TokenType.FORMULA_START.fromValue.apply(this.macros.getDefinition()));
        }
        if (this.args != null) {
            if (this.strategy == MacroProcessorBase.END) {
                result.append(TokenType.FORMULA_END.fromValue.apply(this.args.toString()));
            } else {
                result.append(this.args.toString());
            }
        }
        if (this.strategy == MacroProcessorBase.END) {
            result.append((CharSequence)this.text);
        }
        return result.toString();
    }

    public static interface ContextedTask<O> {
        public O apply(@Nonnull EvaluationContext var1) throws Exception;
    }
}

