/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Base64;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.model.impl.MixInIdImpl;
import org.qubership.atp.dataset.service.rest.MixInIdSerializer;

@JsonSerialize(using=MixInIdSerializer.class)
public interface MixInId {
    @JsonCreator
    public static MixInId fromString(@Nonnull String value) {
        if (value.length() < 36) {
            throw new RuntimeException("Can not parse uuid from " + value);
        }
        UUID uuid = UUID.fromString(value.substring(0, 36));
        String metadata = null;
        if (value.length() > 36) {
            metadata = value.substring(36);
            metadata = new String(Base64.getUrlDecoder().decode(metadata), MixInIdSerializer.CHARSET);
        }
        return new MixInIdImpl(uuid, metadata);
    }

    @Nonnull
    default public String serialize() {
        String metadata = "";
        if (this.getMetadata() != null) {
            metadata = Base64.getUrlEncoder().encodeToString(this.getMetadata().getBytes(MixInIdSerializer.CHARSET));
        }
        return this.getUuid() + metadata;
    }

    @Nonnull
    public UUID getUuid();

    public void setUuid(@Nonnull UUID var1);

    @Nullable
    public String getMetadata();

    public void setMetadata(@Nullable String var1);
}

