/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.utils.tree.TraverseVisitor;

public abstract class AbstractDslUiHandler
implements TraverseVisitor<DataSetList, Attribute> {
    private final AttrUiHandler attrH = new AttrUiHandler();
    private final boolean expandAll;

    public AbstractDslUiHandler(boolean expandAll) {
        this.expandAll = expandAll;
    }

    protected abstract void attributeStarts(Attribute var1);

    protected abstract void goForwardUnderAttribute();

    protected abstract void goBackFromAttribute();

    protected abstract void attributeEnds();

    @Override
    @Nullable
    public Iterator<? extends Attribute> getChildren(@Nonnull DataSetList item) {
        return item.getAttributes().iterator();
    }

    @Override
    @Nonnull
    public TraverseVisitor<?, DataSetList> backToPreviousParent() {
        return this.attrH;
    }

    @Override
    @Nonnull
    public TraverseVisitor<Attribute, ?> forwardToNewParent(@Nonnull DataSetList parent) {
        return this.attrH;
    }

    private class AttrUiHandler
    implements TraverseVisitor<Attribute, DataSetList> {
        private AttrUiHandler() {
        }

        @Override
        public void notifyItemStarts(Attribute item) {
            AbstractDslUiHandler.this.attributeStarts(item);
        }

        @Override
        public void notifyProcessingChildren() {
            AbstractDslUiHandler.this.goForwardUnderAttribute();
        }

        @Override
        public void notifyChildrenProcessed() {
            AbstractDslUiHandler.this.goBackFromAttribute();
        }

        @Override
        public void notifyItemEnds() {
            AbstractDslUiHandler.this.attributeEnds();
        }

        @Override
        @Nonnull
        public TraverseVisitor<?, Attribute> backToPreviousParent() {
            return AbstractDslUiHandler.this;
        }

        @Override
        @Nonnull
        public TraverseVisitor<DataSetList, ?> forwardToNewParent(@Nonnull Attribute parent) {
            return AbstractDslUiHandler.this;
        }

        @Override
        @Nullable
        public Iterator<? extends DataSetList> getChildren(@Nonnull Attribute item) {
            if (AbstractDslUiHandler.this.expandAll && item.getType() == AttributeType.DSL) {
                return item.getDataSetListReference() == null ? null : Iterators.singletonIterator((Object)item.getDataSetListReference());
            }
            return null;
        }
    }
}

