/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.collect.Iterators;
import com.google.common.io.Files;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.qubership.atp.dataset.model.utils.AbstractDsUiHandler;
import org.qubership.atp.dataset.model.utils.CheckedConsumer;
import org.qubership.atp.dataset.model.utils.OverlapItem;
import org.qubership.atp.dataset.model.utils.OverlapIterator;
import org.qubership.atp.dataset.model.utils.tree.RefsVisitor;
import org.qubership.atp.dataset.service.direct.macros.DsEvaluator;

public class AtpDsSerializer
extends StdSerializer<DataSet> {
    private final DsEvaluator evaluator;

    public AtpDsSerializer(@Nonnull DsEvaluator evaluator) {
        super(DataSet.class);
        this.evaluator = evaluator;
    }

    private static ObjectMapper mapper(@Nonnull DsEvaluator evaluator) {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer(DataSet.class, (JsonSerializer)new AtpDsSerializer(evaluator));
        mapper.registerModule((Module)module);
        return mapper;
    }

    public static String writeValueAsString(@Nonnull DataSet ds, @Nonnull DsEvaluator evaluator) throws JsonProcessingException {
        return AtpDsSerializer.mapper(evaluator).writeValueAsString((Object)ds);
    }

    public static void writeValue(@Nonnull OutputStream os, @Nonnull DataSet ds, @Nonnull DsEvaluator evaluator) throws IOException {
        AtpDsSerializer.mapper(evaluator).writeValue(os, (Object)ds);
    }

    public void serialize(DataSet value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Handler h = new Handler(this.evaluator, new SneakyWriter(gen));
        RefsVisitor<DataSet, Attribute> visitor = new RefsVisitor<DataSet, Attribute>((Iterator<DataSet>)Iterators.singletonIterator((Object)value), h, null);
        while (visitor.hasNext()) {
            visitor.next();
        }
    }

    private static class Handler
    extends AbstractDsUiHandler {
        private final Deque<Attribute> groupsPath = new ArrayDeque<Attribute>();
        private final SneakyWriter sneaky;
        private final DsEvaluator evaluator;

        public Handler(DsEvaluator evaluator, SneakyWriter sneaky) {
            this.evaluator = evaluator;
            this.sneaky = sneaky;
        }

        @Override
        @Nullable
        public Iterator<? extends Attribute> getChildren(@Nonnull DataSetList item) {
            return item.getAttributes().stream().filter(attr -> AttributeType.DSL == attr.getType()).iterator();
        }

        @Override
        protected void dslStarts(DataSetList dsl) {
            List collect;
            super.dslStarts(dsl);
            if (this.dslDepth == 0) {
                this.sneaky.write(JsonGenerator::writeStartObject);
            }
            if (!(collect = this.curDsl.getAttributes().stream().filter(attr -> AttributeType.DSL != attr.getType()).collect(Collectors.toList())).isEmpty()) {
                this.sneaky.write(gen -> {
                    gen.writeFieldName("parameters");
                    gen.writeStartObject();
                    for (Attribute attribute : collect) {
                        this.writeAttr(attribute, true);
                    }
                    gen.writeEndObject();
                });
            }
        }

        @Override
        protected void goForwardUnderDsl() {
            super.goForwardUnderDsl();
            this.sneaky.write(gen -> {
                gen.writeFieldName("groups");
                gen.writeStartObject();
            });
        }

        @Override
        protected void goBackFromDsl() {
            this.sneaky.write(JsonGenerator::writeEndObject);
            super.goBackFromDsl();
        }

        @Override
        protected void dslEnds() {
            if (this.dslDepth == 0) {
                this.sneaky.write(JsonGenerator::writeEndObject);
            }
            this.curDsl = null;
        }

        private void writeAttr(Attribute attr, boolean doClose) {
            Optional<Object> valueRefOpt;
            Optional<Object> valueOpt;
            List<UUID> attrPath = this.groupsPath.stream().map(Identified::getId).collect(Collectors.toList());
            OverlapIterator overlapIterator = OverlapIterator.create(this.curDs, attr.getId(), attrPath);
            OverlapItem context = (OverlapItem)overlapIterator.next();
            Optional<Parameter> parameterOpt = context.getParameter();
            if (parameterOpt.isPresent()) {
                Parameter param = parameterOpt.get();
                OverlapItem.Reachable reachable = context.asReachable();
                if (AttributeType.FILE == attr.getType()) {
                    Optional<AtpFileData> fileData = Optional.ofNullable(param.getFileData()).map(AtpFileData::create);
                    valueOpt = fileData.map(AtpFileData::getUniqueFileName);
                    valueRefOpt = fileData;
                } else {
                    valueOpt = this.evaluator.apply(reachable);
                    valueRefOpt = Optional.empty();
                }
            } else {
                valueOpt = Optional.empty();
                valueRefOpt = Optional.empty();
            }
            this.sneaky.write(gen -> {
                gen.writeFieldName(attr.getName());
                gen.writeStartObject();
                gen.writeFieldName("type");
                gen.writeObject((Object)attr.getType());
                if (valueOpt.isPresent()) {
                    gen.writeFieldName("value");
                    gen.writeObject(valueOpt.get());
                }
                if (valueRefOpt.isPresent()) {
                    gen.writeFieldName("valueRef");
                    gen.writeObject(valueRefOpt.get());
                }
                if (doClose) {
                    gen.writeEndObject();
                }
            });
        }

        @Override
        protected void attributeStarts(Attribute attr) {
            this.curAttr = attr;
        }

        @Override
        protected void goForwardUnderAttribute() {
            this.writeAttr(this.curAttr, false);
            this.groupsPath.add(this.curAttr);
            this.curAttr = null;
        }

        @Override
        protected void goBackFromAttribute() {
            this.curAttr = this.groupsPath.removeLast();
            this.sneaky.write(JsonGenerator::writeEndObject);
        }
    }

    private static class SneakyWriter {
        private final JsonGenerator gen;

        private SneakyWriter(JsonGenerator gen) {
            this.gen = gen;
        }

        private static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
            throw e;
        }

        public void write(CheckedConsumer<JsonGenerator, IOException> consumer) {
            try {
                consumer.accept(this.gen);
            }
            catch (IOException e) {
                SneakyWriter.sneakyThrow(e);
            }
        }
    }

    private static class AtpFileData {
        private final String uniqueFileName;
        private final String contentType;
        private final String url;

        private AtpFileData(String uniqueFileName, String contentType, String url) {
            this.uniqueFileName = uniqueFileName;
            this.contentType = contentType;
            this.url = url;
        }

        public static AtpFileData create(@Nonnull FileData data) {
            String uniqueFileName = data.getParameterUuid() + "." + Files.getFileExtension((String)data.getFileName());
            return new AtpFileData(uniqueFileName, data.getContentType(), data.getUrl());
        }

        @JsonIgnore
        public String getUniqueFileName() {
            return this.uniqueFileName;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

