/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils;

import com.google.common.collect.Iterators;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.utils.AbstractDsUiHandler;
import org.qubership.atp.dataset.model.utils.OverlapItem;
import org.qubership.atp.dataset.model.utils.OverlapIterator;
import org.qubership.atp.dataset.service.direct.macros.DsEvaluator;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManAttribute;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManParameter;

public class DsAttrPathUiHandler
extends AbstractDsUiHandler {
    private final DsEvaluator evaluator;
    private final List<UUID> attrPath;
    private final Deque<Attribute> groupsPath = new ArrayDeque<Attribute>();
    private boolean isLeaf = false;
    private UiManAttribute result = null;
    private Deque<UiManAttribute> convertedGroupsPath = new ArrayDeque<UiManAttribute>();

    public DsAttrPathUiHandler(DsEvaluator evaluator, List<UUID> attrPath) {
        this.evaluator = evaluator;
        this.attrPath = attrPath;
    }

    public UiManAttribute getAttribute() {
        return this.result;
    }

    private UiManAttribute convertAttribute(Attribute targetAttr) {
        UiManAttribute result = new UiManAttribute();
        result.setSource(targetAttr);
        List<UUID> attrPath = this.groupsPath.stream().map(Identified::getId).collect(Collectors.toList());
        OverlapIterator overlapIterator = OverlapIterator.create(this.curDs, targetAttr.getId(), attrPath);
        OverlapItem context = (OverlapItem)overlapIterator.next();
        Optional<Parameter> parameterOpt = context.getParameter();
        if (parameterOpt.isPresent()) {
            OverlapItem.Reachable reachable = context.asReachable();
            Parameter parameter = parameterOpt.get();
            Optional<String> valueOpt = this.evaluator.apply(reachable);
            Optional<?> valueRefOpt = reachable.getValueRef();
            boolean overlap = reachable.isOverlap();
            if (valueOpt.isPresent() || valueRefOpt.isPresent() || overlap) {
                result.getParameters().add(new UiManParameter(parameter, reachable.getSourceDs(), overlap, valueOpt.orElse(null), valueRefOpt.orElse(null)));
            }
        }
        return result;
    }

    @Override
    protected void goBackFromAttribute() {
        super.goBackFromAttribute();
        this.isLeaf = false;
        if (this.groupsPath.size() >= this.attrPath.size()) {
            UiManAttribute convertedAttr = this.convertedGroupsPath.removeLast();
            if (this.convertedGroupsPath.isEmpty()) {
                this.result = convertedAttr;
            } else {
                this.convertedGroupsPath.getLast().getAttributes().add(convertedAttr);
            }
        }
        this.groupsPath.removeLast();
    }

    @Override
    protected void attributeStarts(Attribute attr) {
        super.attributeStarts(attr);
        this.isLeaf = true;
    }

    @Override
    @Nullable
    protected Iterator<? extends Attribute> getChildren(@Nonnull DataSetList item) {
        if (this.dslDepth < this.attrPath.size()) {
            UUID attrId = this.attrPath.get(this.dslDepth);
            return item.getAttributes().stream().filter(attr -> attrId.equals(attr.getId())).findAny().map(Iterators::singletonIterator).orElse(null);
        }
        return item.getAttributes().iterator();
    }

    @Override
    protected void goForwardUnderAttribute() {
        super.goForwardUnderAttribute();
        this.isLeaf = false;
        if (this.groupsPath.size() >= this.attrPath.size() - 1) {
            UiManAttribute convertedAttr = this.convertAttribute(this.curAttr);
            this.convertedGroupsPath.add(convertedAttr);
        }
        this.groupsPath.add(this.curAttr);
    }

    @Override
    protected void attributeEnds() {
        if (this.isLeaf) {
            UiManAttribute leafAttr = this.convertAttribute(this.curAttr);
            if (!this.convertedGroupsPath.isEmpty()) {
                this.convertedGroupsPath.getLast().getAttributes().add(leafAttr);
            } else {
                this.result = leafAttr;
            }
        }
    }
}

