/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelRowsReader {
    private static final int SHEET_NUMBER = 0;

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> Stream<List<String>> read(File file) {
        try (BufferedInputStream inp = new BufferedInputStream(new FileInputStream(file));){
            Stream<List<String>> stream;
            try (XSSFWorkbook wb = new XSSFWorkbook((InputStream)inp);){
                XSSFSheet sheet = wb.getSheetAt(0);
                Stream<Row> stream2 = StreamSupport.stream(sheet.spliterator(), false);
                stream = stream2.map(ExcelRowsReader.rowsMapper());
            }
            return stream;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Problems processing excel file: " + file.getName(), ex);
        }
    }

    private static Function<Row, List<String>> rowsMapper() {
        return row -> {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < row.getPhysicalNumberOfCells(); ++i) {
                list.add(row.getCell(i, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK).toString());
            }
            return list;
        };
    }
}

