/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributePath;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.ParameterOverlap;
import org.qubership.atp.dataset.model.utils.OverlapItem;
import org.qubership.atp.dataset.model.utils.OverlapLayers;

public class OverlapIterator
extends AbstractIterator<OverlapItem> {
    private final DataSet sourceDs;
    private final Collection<UUID> attrPath;
    private final UUID targetAttrId;
    private final List<Attribute> resolvedAttrPath;
    private final Iterator<DataSet> layersToCheck;
    private DataSet lastDs = null;
    private Supplier<OverlapItem> nextStrategy;

    OverlapIterator(@Nonnull DataSet sourceDs, @Nullable Collection<UUID> attrPath, @Nonnull UUID targetAttrId, @Nonnull Iterator<DataSet> layersToCheck, @Nonnull List<Attribute> resolvedAttrPath) {
        this.attrPath = attrPath;
        this.sourceDs = sourceDs;
        this.targetAttrId = targetAttrId;
        this.layersToCheck = layersToCheck;
        this.resolvedAttrPath = resolvedAttrPath;
        this.nextStrategy = attrPath == null || attrPath.isEmpty() ? this::checkTargetAttr : new CheckAttrPath(new ArrayDeque<UUID>(attrPath));
    }

    public static OverlapIterator create(@Nonnull DataSet dataSet, @Nonnull UUID targetAttrId, @Nullable Collection<UUID> attrPathIds) {
        return OverlapLayers.overlapIterator(dataSet, targetAttrId, attrPathIds);
    }

    public static OverlapIterator from(@Nonnull DataSet ds, @Nonnull Attribute targetAttribute, @Nonnull List<Attribute> attributePath) {
        return OverlapIterator.create(ds, targetAttribute.getId(), attributePath.stream().map(Identified::getId).collect(Collectors.toList()));
    }

    @Nonnull
    public static OverlapIterator from(@Nonnull AttributePath attributePath) {
        return OverlapIterator.from(attributePath.getDataSet(), attributePath.getTargetAttribute(), attributePath.getPath());
    }

    private static Optional<ParameterOverlap> getCachedOverlap(DataSet ds, UUID targetAttrId, Iterable<UUID> attrIdPath) {
        return ds.getParameters().stream().filter(Parameter::isOverlap).map(Parameter::asOverlap).filter(overlap -> {
            AttributePath attrPath = overlap.getAttributePath();
            if (!targetAttrId.equals(attrPath.getTargetAttribute().getId())) {
                return false;
            }
            Iterator attrIdPathIter = attrIdPath.iterator();
            return attrPath.getPath().stream().allMatch(attr -> {
                if (attrIdPathIter.hasNext()) {
                    return ((UUID)attrIdPathIter.next()).equals(attr.getId());
                }
                return false;
            });
        }).findAny();
    }

    private static Optional<Parameter> getCachedParameter(DataSet currentDs, UUID targetAttrId) {
        return currentDs.getParameters().stream().filter(parameter -> parameter.getAttribute().getId().equals(targetAttrId)).findAny();
    }

    private static Optional<Attribute> getCachedAttribute(DataSetList dsl, UUID targetAttrId) {
        return dsl.getAttributes().stream().filter(attribute -> targetAttrId.equals(attribute.getId())).findAny();
    }

    protected OverlapItem computeNext() {
        OverlapItem result = null;
        while (this.nextStrategy != null && result == null) {
            result = this.nextStrategy.get();
        }
        if (result == null) {
            return (OverlapItem)this.endOfData();
        }
        return result;
    }

    @Nonnull
    private OverlapItem canNotBeReached(UUID attrId) {
        assert (!this.layersToCheck.hasNext());
        assert (this.lastDs != null);
        this.nextStrategy = null;
        return new OverlapItem.Unreachable(this.sourceDs, this.attrPath, this.targetAttrId, this.lastDs, attrId);
    }

    @Nonnull
    private OverlapItem checkTargetAttr() {
        if (!this.layersToCheck.hasNext()) {
            return this.canNotBeReached(this.targetAttrId);
        }
        this.nextStrategy = null;
        this.lastDs = this.layersToCheck.next();
        Optional<Parameter> param = OverlapIterator.getCachedParameter(this.lastDs, this.targetAttrId);
        if (param.isPresent()) {
            return new OverlapItem.DefaultInitialized(this.sourceDs, this.resolvedAttrPath, this.lastDs, param.get());
        }
        Optional<Attribute> attr = OverlapIterator.getCachedAttribute(this.lastDs.getDataSetList(), this.targetAttrId);
        if (attr.isPresent()) {
            return new OverlapItem.DefaultUninitialized(this.sourceDs, this.resolvedAttrPath, attr.get(), this.lastDs);
        }
        return this.canNotBeReached(this.targetAttrId);
    }

    private class CheckAttrPath
    implements Supplier<OverlapItem> {
        private final Deque<UUID> attrPathToCheck;

        private CheckAttrPath(Deque<UUID> attrPathToCheck) {
            this.attrPathToCheck = attrPathToCheck;
        }

        @Override
        public OverlapItem get() {
            assert (OverlapIterator.this.attrPath != null);
            assert (!this.attrPathToCheck.isEmpty());
            if (!OverlapIterator.this.layersToCheck.hasNext()) {
                return OverlapIterator.this.canNotBeReached(this.attrPathToCheck.getFirst());
            }
            OverlapIterator.this.lastDs = (DataSet)OverlapIterator.this.layersToCheck.next();
            Optional cachedOverlap = OverlapIterator.getCachedOverlap(OverlapIterator.this.lastDs, OverlapIterator.this.targetAttrId, this.attrPathToCheck);
            OverlapItem.Overlap result = cachedOverlap.map(overlap -> new OverlapItem.Overlap(OverlapIterator.this.sourceDs, OverlapIterator.this.resolvedAttrPath, OverlapIterator.this.lastDs, (ParameterOverlap)overlap)).orElse(null);
            this.attrPathToCheck.removeFirst();
            if (this.attrPathToCheck.isEmpty()) {
                OverlapIterator.this.nextStrategy = () -> OverlapIterator.this.checkTargetAttr();
            }
            return result;
        }
    }
}

