/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.impl;

import java.sql.Timestamp;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.service.direct.ConcurrentModificationService;
import org.qubership.atp.dataset.service.direct.DataSetListService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class ConcurrentModificationServiceImpl
implements ConcurrentModificationService {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentModificationServiceImpl.class);
    private final DataSetListService dataSetListService;

    @Override
    public HttpStatus getHttpStatus(@Nullable UUID entityId, @Nullable Long modifiedWhen) {
        log.debug("ConcurrentModificationServiceImpl#getHttpStatus(entityId: {}, modifiedWhen: {})", (Object)entityId, (Object)modifiedWhen);
        if (Objects.isNull(entityId) || Objects.isNull(modifiedWhen)) {
            return HttpStatus.OK;
        }
        Timestamp entityModifiedWhen = this.dataSetListService.getModifiedWhen(entityId);
        log.debug("Entity modifiedWhen: {}", (Object)entityModifiedWhen);
        long entityModifiedWhenLong = entityModifiedWhen.getTime();
        log.debug("Entity entityModifiedWhenLong: {}", (Object)entityModifiedWhenLong);
        return entityModifiedWhenLong == modifiedWhen ? HttpStatus.OK : HttpStatus.IM_USED;
    }

    public ConcurrentModificationServiceImpl(DataSetListService dataSetListService) {
        this.dataSetListService = dataSetListService;
    }
}

