/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.impl;

import com.mysema.commons.lang.Pair;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.qubership.atp.dataset.db.DataSetListRepository;
import org.qubership.atp.dataset.db.TestPlanRepository;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.TestPlan;
import org.qubership.atp.dataset.service.direct.TestPlanService;
import org.qubership.atp.dataset.versioning.service.DataSetListSnapshotService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TestPlanServiceImpl
implements TestPlanService {
    private final TestPlanRepository repo;
    private final DataSetListRepository dataSetListRepo;
    private final Provider<UserInfo> userInfoProvider;
    private final DataSetListSnapshotService dataSetListSnapshotService;

    @Override
    @Nonnull
    public Pair<TestPlan, Boolean> create(@Nonnull UUID visibilityArea, @Nonnull String name) {
        return this.repo.create(name, visibilityArea);
    }

    @Override
    @Nonnull
    public List<TestPlan> getAll(@Nonnull UUID visibilityArea) {
        return this.repo.getAll(visibilityArea);
    }

    @Override
    @Nonnull
    public List<TestPlan> getAll() {
        return this.repo.getAll();
    }

    @Override
    public boolean rename(@Nonnull UUID id, @Nonnull String name) {
        TestPlan testPlan = this.get(id);
        if (testPlan == null) {
            return false;
        }
        return this.repo.rename(id, name);
    }

    @Override
    public TestPlan getByNameUnderVisibilityArea(UUID visibilityArea, String name) {
        return this.repo.getByNameUnderVisibilityArea(visibilityArea, name);
    }

    @Override
    public boolean delete(@Nonnull UUID testPlanId) {
        UUID modifiedBy = ((UserInfo)this.userInfoProvider.get()).getId();
        Timestamp modifiedWhen = Timestamp.from(Instant.now());
        return this.repo.delete(testPlanId, modifiedBy, modifiedWhen);
    }

    @Override
    @Transactional
    public boolean delete(@Nonnull UUID vaId, @Nonnull String name) {
        UUID modifiedBy = ((UserInfo)this.userInfoProvider.get()).getId();
        Timestamp modifiedWhen = Timestamp.from(Instant.now());
        TestPlan testPlan = this.getByNameUnderVisibilityArea(vaId, name);
        if (testPlan != null) {
            this.dataSetListRepo.getUnderTestPlan(testPlan.getId()).forEach(dataSetList -> this.dataSetListSnapshotService.commitEntity(dataSetList.getId()));
        }
        return this.repo.delete(vaId, name, modifiedBy, modifiedWhen);
    }

    @Override
    public List<DataSetList> getChildren(@Nonnull UUID testPlanId) {
        return this.dataSetListRepo.getUnderTestPlan(testPlanId);
    }

    @Override
    @Nullable
    public TestPlan get(@Nonnull UUID id) {
        return this.repo.getById(id);
    }

    @Override
    public boolean existsById(@NotNull UUID id) {
        return this.repo.existsById(id);
    }

    public TestPlanServiceImpl(TestPlanRepository repo, DataSetListRepository dataSetListRepo, Provider<UserInfo> userInfoProvider, DataSetListSnapshotService dataSetListSnapshotService) {
        this.repo = repo;
        this.dataSetListRepo = dataSetListRepo;
        this.userInfoProvider = userInfoProvider;
        this.dataSetListSnapshotService = dataSetListSnapshotService;
    }
}

