/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.importexport.converters;

import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.logging.log4j.util.Strings;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.service.direct.importexport.converters.AttributeExportConverter;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManAttribute;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManParameter;
import org.springframework.stereotype.Component;

@Component
public class DatasetLinkAttributeExportConverter
implements AttributeExportConverter {
    @Override
    public void mapAttributeToRow(SXSSFRow row, Set<UUID> datasetIds, UiManAttribute attribute) {
        DataSetList reference = attribute.getSource().getDataSetListReference();
        HashMap mapParameterWithDataSet = new HashMap();
        attribute.getParameters().forEach(parameter -> mapParameterWithDataSet.put(parameter.getDataSet(), parameter));
        int nextCellIndex = 2;
        for (UUID datasetId : datasetIds) {
            SXSSFCell cell = row.createCell(nextCellIndex++);
            UiManParameter parameter2 = (UiManParameter)mapParameterWithDataSet.get(datasetId);
            if (!Objects.nonNull(reference) || !Objects.nonNull(parameter2) || !Strings.isNotBlank((String)parameter2.getValue().toString())) continue;
            cell.setCellValue(String.format("%s %s %s", reference.getName(), "->", parameter2.getValue()));
        }
    }
}

