/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.importexport.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamUtils {
    private static final Logger log = LoggerFactory.getLogger(StreamUtils.class);

    public static <T> Set<UUID> extractIds(Collection<T> entities, Function<T, UUID> extractor) {
        if (entities == null) {
            return Collections.emptySet();
        }
        return StreamUtils.getIdsStream(entities, extractor).collect(Collectors.toSet());
    }

    private static <T> Stream<UUID> getIdsStream(Collection<T> entities, Function<T, UUID> extractor) {
        return entities.stream().map(extractor).filter(Objects::nonNull);
    }

    private static <T> Stream<T> stream(Iterable<T> entities) {
        return StreamSupport.stream(entities.spliterator(), false);
    }

    public static <T> Map<String, UUID> toNameIdEntityMap(Iterable<T> entities, Function<T, String> keyExtractor, Function<T, UUID> valueExtractor) {
        return StreamUtils.stream(entities).collect(Collectors.toMap(keyExtractor, valueExtractor));
    }

    public static <T> Map<String, T> toNameEntityMap(Iterable<T> entities, Function<T, String> keyExtractor) {
        return StreamUtils.stream(entities).collect(Collectors.toMap(keyExtractor, Function.identity()));
    }

    public static <T, R> Map<R, T> toEntityMap(Iterable<T> entities, Function<T, R> keyExtractor) {
        return StreamUtils.stream(entities).collect(Collectors.toMap(keyExtractor, Function.identity()));
    }

    public static <T> Map<UUID, List<T>> toEntityListMap(Iterable<T> entities, Function<T, UUID> keyExtractor) {
        return StreamUtils.stream(entities).collect(Collectors.groupingBy(keyExtractor));
    }

    private StreamUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

