/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.macros;

import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.MixInId;
import org.qubership.atp.dataset.model.utils.OverlapItem;
import org.qubership.atp.dataset.service.direct.macros.DsEvaluator;
import org.qubership.atp.dataset.service.direct.macros.EvaluateDsParamStrategy;
import org.qubership.atp.dataset.service.direct.macros.schange.EvaluateDsStructureStrategy;

public class CachingParamEvaluator
implements DsEvaluator {
    private final EvaluateDsParamStrategy evalParamStrategy;
    private final EvaluateDsStructureStrategy structureChangeStrategy;

    public CachingParamEvaluator(EvaluateDsParamStrategy evalParamStrategy, EvaluateDsStructureStrategy structureChangeStrategy) {
        this.evalParamStrategy = evalParamStrategy;
        this.structureChangeStrategy = structureChangeStrategy;
    }

    @Override
    @Nonnull
    public Stream<DataSet> getDataSets(@Nonnull DataSetList parent, @Nonnull Stream<DataSet> children) {
        return this.structureChangeStrategy.getDataSets(parent, children);
    }

    @Override
    @Nullable
    public DataSet getDataSetById(MixInId dataSet) {
        return this.structureChangeStrategy.getDataSetById(dataSet);
    }

    @Override
    public void close() {
    }

    @Override
    @Nonnull
    public Optional<String> apply(@Nonnull OverlapItem.Reachable target) {
        return this.evalParamStrategy.apply(target);
    }

    @Override
    @Nonnull
    public String evaluateText(@Nonnull DataSet ds, @Nonnull String text) {
        return this.evalParamStrategy.evaluateText(ds, text);
    }
}

