/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.delegates;

import java.util.Objects;
import java.util.UUID;
import javax.persistence.EntityNotFoundException;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.junit.jupiter.api.Assertions;
import org.qubership.atp.dataset.db.jpa.entities.AbstractAttributeEntity;
import org.qubership.atp.dataset.db.jpa.entities.AbstractUuidBasedEntity;
import org.qubership.atp.dataset.db.jpa.entities.AttributeEntity;
import org.qubership.atp.dataset.db.jpa.entities.AttributeKeyEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetEntity;
import org.qubership.atp.dataset.db.jpa.entities.ListValueEntity;
import org.qubership.atp.dataset.db.jpa.entities.ParameterEntity;
import org.qubership.atp.dataset.exception.file.FileDsNotFoundException;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.qubership.atp.dataset.service.jpa.delegates.AbstractObjectWrapper;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;

public class Parameter
extends AbstractObjectWrapper<ParameterEntity> {
    private static final long serialVersionUID = -7205269656851827042L;

    public Parameter(ParameterEntity entity) {
        super(entity);
    }

    public UUID getId() {
        return ((ParameterEntity)this.entity).getId();
    }

    public void setId(UUID id) {
        ((ParameterEntity)this.entity).setId(id);
    }

    public String getStringValue() {
        return ((ParameterEntity)this.entity).getStringValue();
    }

    public void setStringValue(String value) {
        ((ParameterEntity)this.entity).setStringValue(value);
        this.save(this.entity);
    }

    public UUID getFileValueId() {
        return ((ParameterEntity)this.entity).getFileValueId();
    }

    public FileData getFileData() {
        return gridFsService.getFileInfo(this.getId());
    }

    public FileData getFileDataIfExist() {
        try {
            return gridFsService.getFileInfo(this.getId());
        }
        catch (FileDsNotFoundException ex) {
            return null;
        }
    }

    public void setFileValueId(UUID fileValueId) {
        ((ParameterEntity)this.entity).setFileValueId(fileValueId);
        this.save(this.entity);
    }

    public DataSet getDataSet() {
        return modelsProvider.getDataSet(((ParameterEntity)this.entity).getDataSet());
    }

    public UUID getDataSetId() {
        return ((ParameterEntity)this.entity).getDataSetId();
    }

    public DataSet getDataSetReferenceValue() {
        UUID dataSetReferenceId = ((ParameterEntity)this.entity).getDataSetReferenceId();
        if (dataSetReferenceId == null) {
            return null;
        }
        return modelsProvider.getDataSetById(dataSetReferenceId);
    }

    public UUID getDataSetReferenceId() {
        return ((ParameterEntity)this.entity).getDataSetReferenceId();
    }

    public void setDataSetReferenceId(UUID dataSetId) {
        ((ParameterEntity)this.entity).setDataSetReferenceId(dataSetId);
        this.save(this.entity);
    }

    public Attribute getAttribute() {
        AbstractAttributeEntity attribute = ((ParameterEntity)this.entity).getAttribute();
        if (attribute == null || attribute.isAttributeKey()) {
            return null;
        }
        if (attribute instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)attribute;
            LazyInitializer initializer = hibernateProxy.getHibernateLazyInitializer();
            return modelsProvider.getAttribute((AttributeEntity)initializer.getImplementation());
        }
        return modelsProvider.getAttribute(attribute);
    }

    public boolean isOverlap() {
        AbstractAttributeEntity attribute = ((ParameterEntity)this.entity).getAttribute();
        return attribute == null || attribute.isAttributeKey();
    }

    public UUID getListValueId() {
        return Objects.isNull(((ParameterEntity)this.entity).getListValue()) ? null : ((ParameterEntity)this.entity).getListValue().getId();
    }

    public AttributeKey getAttributeKey() {
        return modelsProvider.getAttributeKey((AbstractUuidBasedEntity)entityManager.find(AttributeKeyEntity.class, (Object)((ParameterEntity)this.entity).getAttribute().getId()));
    }

    public UUID getAttributeId() {
        return ((ParameterEntity)this.entity).getAttribute().getId();
    }

    public ListValueEntity getListValue() {
        return ((ParameterEntity)this.entity).getListValue();
    }

    public void setListValueId(UUID listValueId) {
        if (listValueId == null) {
            ((ParameterEntity)this.entity).setListValue(null);
        } else {
            ListValueEntity listValue = (ListValueEntity)entityManager.find(ListValueEntity.class, (Object)listValueId);
            ((ParameterEntity)this.entity).setListValue(listValue);
        }
        this.save(this.entity);
    }

    public String getParameterValueByType() {
        Attribute attribute = this.getAttribute();
        if (attribute == null) {
            attribute = this.getAttributeKey().getAttribute();
        }
        switch (attribute.getAttributeType()) {
            case CHANGE: 
            case ENCRYPTED: 
            case TEXT: {
                return this.getStringValue();
            }
            case FILE: {
                return this.getId().toString();
            }
            case DSL: {
                return this.getDataSetReferenceId() == null ? null : this.dataReferencedDataSetName();
            }
            case LIST: {
                return this.getListValue() == null ? "" : this.getListValue().getText();
            }
        }
        return null;
    }

    public Object getParameterValueByTypeAsObject() {
        Attribute attribute = this.getAttribute();
        if (attribute == null) {
            attribute = this.getAttributeKey().getAttribute();
        }
        switch (attribute.getAttributeType()) {
            case CHANGE: 
            case ENCRYPTED: 
            case TEXT: {
                return this.getStringValue();
            }
            case FILE: {
                try {
                    return this.getFileData().getFileName();
                }
                catch (FileDsNotFoundException ignore) {
                    return null;
                }
            }
            case DSL: {
                return this.getDataSetReferenceId() == null ? null : this.getDataSetReferenceValue().getShortInfo();
            }
            case LIST: {
                return this.getListValue() == null ? "" : this.getListValue().getText();
            }
        }
        return null;
    }

    public String dataReferencedDataSetName() {
        String nativeQuery = "select name from dataset where id = :ds_id";
        try {
            return (String)entityManager.createNativeQuery(nativeQuery).setParameter("ds_id", (Object)this.getDataSetReferenceId()).getSingleResult();
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    public void setDataSet(UUID dataSetId) {
        DataSet dataSet = modelsProvider.getDataSetById(dataSetId);
        Assertions.assertNotNull((Object)dataSet, (String)("Cannot find data set by id " + dataSetId));
        ((ParameterEntity)this.entity).setDataSet((DataSetEntity)dataSet.getEntity());
    }

    public void setAttribute(UUID attributeId) {
        AbstractObjectWrapper attribute = modelsProvider.getAttributeById(attributeId);
        if (attribute == null) {
            attribute = modelsProvider.getAttributeKeyById(attributeId);
        }
        Assertions.assertNotNull((Object)attribute, (String)("Cannot find attribute by id " + attributeId));
        ((ParameterEntity)this.entity).setAttribute((AbstractAttributeEntity)attribute.getEntity());
    }
}

