/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.delegates;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.dataset.db.jpa.entities.AbstractUuidBasedEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetListEntity;
import org.qubership.atp.dataset.db.jpa.entities.FilterEntity;
import org.qubership.atp.dataset.db.jpa.entities.TestPlanEntity;
import org.qubership.atp.dataset.db.jpa.entities.VisibilityAreaEntity;
import org.qubership.atp.dataset.service.jpa.delegates.AbstractObjectWrapper;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;

public class VisibilityArea
extends AbstractObjectWrapper<VisibilityAreaEntity> {
    public VisibilityArea(VisibilityAreaEntity entity) {
        super(entity);
    }

    public UUID getId() {
        return ((VisibilityAreaEntity)this.entity).getId();
    }

    public String getName() {
        return ((VisibilityAreaEntity)this.entity).getName();
    }

    public void setName(String name) {
        ((VisibilityAreaEntity)this.entity).setName(name);
        this.save(this.entity);
    }

    public List<DataSetList> getDataSetLists() {
        LinkedList<DataSetList> result = new LinkedList<DataSetList>();
        ((VisibilityAreaEntity)this.entity).getDataSetLists().forEach(dataSetListEntity -> result.add(modelsProvider.getDataSetList((AbstractUuidBasedEntity)dataSetListEntity)));
        return result;
    }

    public List<UUID> getDataSetListIds() {
        String nativeQuery = "select cast(id as varchar) from datasetlist where visibility_area_id = :va_id";
        LinkedList<UUID> result = new LinkedList<UUID>();
        entityManager.createNativeQuery(nativeQuery).setParameter("va_id", (Object)this.getId()).getResultList().forEach(o -> result.add(UUID.fromString((String)o)));
        return result;
    }

    public DataSetList getDataSetListByName(String name) {
        String nativeQuery = "select * from datasetlist where visibility_area_id = :va_id and name = :dsl_name";
        List resultList = entityManager.createNativeQuery(nativeQuery, DataSetListEntity.class).setParameter("va_id", (Object)this.getId()).setParameter("dsl_name", (Object)name).getResultList();
        if (resultList == null || resultList.isEmpty()) {
            return null;
        }
        return modelsProvider.getDataSetList((AbstractUuidBasedEntity)resultList.iterator().next());
    }

    public DataSetList getDataSetListById(UUID id) {
        String nativeQuery = "select * from datasetlist where visibility_area_id = :va_id and id = :dsl_id";
        List resultList = entityManager.createNativeQuery(nativeQuery, DataSetListEntity.class).setParameter("va_id", (Object)this.getId()).setParameter("dsl_id", (Object)id).getResultList();
        if (resultList == null || resultList.isEmpty()) {
            return null;
        }
        return modelsProvider.getDataSetList((AbstractUuidBasedEntity)resultList.iterator().next());
    }

    public DataSetList createDataSetList(String name) {
        Timestamp dslCreationTime = Timestamp.from(Instant.now());
        DataSetListEntity dataSetListEntity = new DataSetListEntity();
        dataSetListEntity.setName(name);
        dataSetListEntity.setVisibilityArea((VisibilityAreaEntity)this.entity);
        dataSetListEntity.setCreatedWhen(dslCreationTime);
        dataSetListEntity.setModifiedWhen(dslCreationTime);
        this.save(dataSetListEntity);
        return modelsProvider.getDataSetList(dataSetListEntity);
    }

    public DataSetList insertDataSetList(UUID id, String name) {
        DataSetListEntity dataSetListEntity = new DataSetListEntity();
        dataSetListEntity.setName(name);
        dataSetListEntity.setVisibilityArea((VisibilityAreaEntity)this.entity);
        this.insert(dataSetListEntity, id);
        return modelsProvider.getDataSetList(dataSetListEntity);
    }

    public List<TestPlanEntity> testPlans() {
        return ((VisibilityAreaEntity)this.entity).getTestPlans();
    }

    public List<FilterEntity> getFilters() {
        return ((VisibilityAreaEntity)this.entity).getFilters();
    }

    @Override
    public void beforeRemove() {
        List<DataSetList> dataSetLists = this.getDataSetLists();
        for (DataSetList dataSetList : dataSetLists) {
            dataSetList.remove();
        }
    }

    public List<String> getDataSetListsNames() {
        List resultList = entityManager.createNativeQuery("select name from datasetlist where visibility_area_id = :va_id").setParameter("va_id", (Object)this.getId()).getResultList();
        if (resultList == null || resultList.isEmpty()) {
            return Collections.emptyList();
        }
        return resultList;
    }
}

