/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.exception.datasetlist.DataSetListNotFoundException;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.jpa.model.dscontext.DataSetListContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataSetListContextService {
    private static final Logger log = LoggerFactory.getLogger(DataSetListContextService.class);
    protected ThreadLocal<List<DataSetListContext>> threadLocalValue = new ThreadLocal();
    @Autowired
    protected ModelsProvider modelsProvider;

    private DataSetListContext getCachedDataSetListContext(UUID dataSetListId, List<Integer> loadedColumns, List<AttributeTypeName> attributeTypesToLoad) {
        List<DataSetListContext> dataSetListContexts = this.threadLocalValue.get();
        if (dataSetListContexts != null) {
            for (DataSetListContext dataSetListContext : dataSetListContexts) {
                if (!dataSetListContext.getDataSetListId().equals(dataSetListId) || !dataSetListContext.getLoadedColumns().containsAll(loadedColumns) || !dataSetListContext.getLoadedAttributes().containsAll(attributeTypesToLoad)) continue;
                return dataSetListContext;
            }
        }
        return null;
    }

    @Transactional(readOnly=true)
    public DataSetListContext getDataSetListContext(UUID dataSetListId, List<Integer> dataSetColumns, List<AttributeTypeName> attributeTypesToLoad, List<UUID> pathRestrictions, Pageable pageable) {
        DataSetList dataSetList = this.modelsProvider.getDataSetListById(dataSetListId);
        if (dataSetList != null) {
            DataSetListContext dataSetListContext = this.getCachedDataSetListContext(dataSetListId, dataSetColumns, attributeTypesToLoad);
            if (dataSetListContext != null) {
                return dataSetListContext;
            }
            DataSetListContext newContext = new DataSetListContext(dataSetList, dataSetColumns, attributeTypesToLoad, pathRestrictions, pageable);
            if (pathRestrictions == null) {
                this.addNewContext(newContext);
            }
            return newContext;
        }
        log.error("Data Set List not found " + dataSetListId);
        throw new DataSetListNotFoundException();
    }

    @Transactional(readOnly=true)
    public DataSetListContext getDataSetListContext(UUID dataSetListId, List<Integer> dataSetColumns, List<AttributeTypeName> attributeTypesToLoad, List<UUID> pathRestrictions) {
        DataSetList dataSetList = this.modelsProvider.getDataSetListById(dataSetListId);
        if (dataSetList != null) {
            DataSetListContext dataSetListContext = this.getCachedDataSetListContext(dataSetListId, dataSetColumns, attributeTypesToLoad);
            if (dataSetListContext != null) {
                return dataSetListContext;
            }
            DataSetListContext newContext = new DataSetListContext(dataSetList, dataSetColumns, attributeTypesToLoad, pathRestrictions);
            if (pathRestrictions == null) {
                this.addNewContext(newContext);
            }
            return newContext;
        }
        log.error("Data Set List not found " + dataSetListId);
        throw new DataSetListNotFoundException();
    }

    private void addNewContext(DataSetListContext newContext) {
        if (this.threadLocalValue.get() == null) {
            this.threadLocalValue.set(new LinkedList());
        }
        this.threadLocalValue.get().add(newContext);
    }

    public void dropLocalThreadCache() {
        this.threadLocalValue.remove();
    }
}

