/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.impl;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.qubership.atp.dataset.db.GridFsRepository;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.service.jpa.impl.macro.MacroContext;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.jpa.model.MacroContextService;
import org.qubership.atp.dataset.service.jpa.model.tree.params.AbstractParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.EncryptedParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.FileParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.ListParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.ReferenceDataSetListParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.TextParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ParameterPositionContext;
import org.qubership.atp.macros.core.calculator.MacrosCalculator;
import org.qubership.atp.macros.core.client.MacrosFeignClient;
import org.qubership.atp.macros.core.converter.MacrosDtoConvertService;
import org.qubership.atp.macros.core.model.Macros;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
public class DataSetParameterProvider {
    @Autowired
    protected GridFsRepository gridFsRepository;
    @Autowired
    protected MacroContextService macroContextService;
    @Autowired
    protected ModelsProvider modelsProvider;
    @Autowired
    protected MacrosFeignClient macrosFeignClient;
    @Autowired
    protected MacrosCalculator macrosCalculator;

    public AbstractParameter getDataSetParameterResolved(UUID dataSetListId, UUID dataSetParameterId, AttributeTypeName attributeType, boolean evaluate, MacroContext macroContext, ParameterPositionContext parameterPositionContext) {
        if (macroContext == null) {
            macroContext = new MacroContext();
            macroContext.setMacroContextService(this.macroContextService);
        }
        Parameter parameter = null;
        if (dataSetParameterId != null) {
            parameter = this.modelsProvider.getParameterById(dataSetParameterId);
        }
        switch (attributeType) {
            case ENCRYPTED: {
                return this.processAsEncryptedDataSetParameter(dataSetListId, parameter, macroContext, parameterPositionContext);
            }
            case CHANGE: 
            case TEXT: {
                return this.processAsTextDataSetParameter(dataSetListId, parameter, evaluate, macroContext, parameterPositionContext);
            }
            case FILE: {
                return this.processAsFileDataSetParameter(parameter, parameterPositionContext);
            }
            case LIST: {
                return this.processAsListDataSetParameter(dataSetListId, parameter, evaluate, macroContext, parameterPositionContext);
            }
            case DSL: {
                return this.processReferenceDataSetParameter(parameter, parameterPositionContext);
            }
        }
        return null;
    }

    private AbstractParameter processAsTextDataSetParameter(UUID dataSetListId, Parameter parameter, boolean evaluate, MacroContext macroContext, ParameterPositionContext parameterPositionContext) {
        if (parameter == null) {
            return new TextParameter(null, parameterPositionContext);
        }
        TextParameter textParameter = new TextParameter(parameter.getStringValue(), evaluate, macroContext, parameterPositionContext);
        Map<ParameterPositionContext, String> cachedEvaluatedValues = this.macroContextService.getCachedEvaluatedValues(dataSetListId);
        textParameter.setCachedValues(cachedEvaluatedValues);
        return textParameter;
    }

    private AbstractParameter processAsEncryptedDataSetParameter(UUID dataSetListId, Parameter parameter, MacroContext macroContext, ParameterPositionContext parameterPositionContext) {
        if (parameter == null) {
            return new EncryptedParameter(null, parameterPositionContext);
        }
        EncryptedParameter encryptedParameter = new EncryptedParameter(parameter.getStringValue(), false, macroContext, parameterPositionContext);
        Map<ParameterPositionContext, String> cachedEvaluatedValues = this.macroContextService.getCachedEvaluatedValues(dataSetListId);
        encryptedParameter.setCachedValues(cachedEvaluatedValues);
        return encryptedParameter;
    }

    private AbstractParameter processAsFileDataSetParameter(Parameter parameter, ParameterPositionContext parameterPositionContext) {
        if (parameter == null) {
            return new FileParameter(parameterPositionContext);
        }
        Optional<FileData> fileDataOptional = this.gridFsRepository.getFileInfo(parameter.getId());
        FileData fileData = null;
        if (fileDataOptional.isPresent()) {
            fileData = fileDataOptional.get();
        }
        return new FileParameter(parameter, fileData, parameterPositionContext);
    }

    private AbstractParameter processAsListDataSetParameter(UUID dataSetListId, Parameter parameter, boolean evaluate, MacroContext macroContext, ParameterPositionContext parameterPositionContext) {
        if (parameter == null) {
            return new ListParameter(null, parameterPositionContext);
        }
        ListParameter listParameter = new ListParameter(parameter.getListValue() != null ? parameter.getListValue().getText() : null, evaluate, macroContext, parameterPositionContext);
        Map<ParameterPositionContext, String> cachedEvaluatedValues = this.macroContextService.getCachedEvaluatedValues(dataSetListId);
        listParameter.setCachedValues(cachedEvaluatedValues);
        return listParameter;
    }

    private AbstractParameter processReferenceDataSetParameter(Parameter parameter, ParameterPositionContext parameterPositionContext) {
        if (parameter == null) {
            return new ReferenceDataSetListParameter(parameterPositionContext);
        }
        return new ReferenceDataSetListParameter(parameter, parameterPositionContext);
    }

    public FileData getFileVariableInfo(UUID parameterId) {
        Optional<FileData> fileInfo = this.gridFsRepository.getFileInfo(parameterId);
        return fileInfo.orElse(null);
    }

    public List<Macros> getAtpMacros(UUID visibilityAreaId) {
        List macrosDtoList = (List)this.macrosFeignClient.findAllByProject(visibilityAreaId).getBody();
        return new MacrosDtoConvertService().convertList(macrosDtoList, Macros.class);
    }

    public MacroContextService getMacroContextService() {
        return this.macroContextService;
    }

    public MacrosCalculator getMacrosCalculator() {
        return this.macrosCalculator;
    }
}

