/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;

public class DataSetListDependencyNode {
    private UUID id;
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<DataSetListDependencyNode> dependencies = new LinkedList<DataSetListDependencyNode>();

    private DataSetListDependencyNode(DataSetList dataSetList) {
        this.id = dataSetList.getId();
        this.name = dataSetList.getName();
        for (DataSetList dependency : dataSetList.getDependencies()) {
            this.dependencies.add(new DataSetListDependencyNode(dependency));
        }
    }

    public static DataSetListDependencyNode getDependencyTree(DataSetList dataSetList) {
        return new DataSetListDependencyNode(dataSetList);
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<DataSetListDependencyNode> getDependencies() {
        return this.dependencies;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDependencies(List<DataSetListDependencyNode> dependencies) {
        this.dependencies = dependencies;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSetListDependencyNode)) {
            return false;
        }
        DataSetListDependencyNode other = (DataSetListDependencyNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<DataSetListDependencyNode> this$dependencies = this.getDependencies();
        List<DataSetListDependencyNode> other$dependencies = other.getDependencies();
        return !(this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSetListDependencyNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<DataSetListDependencyNode> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        return result;
    }

    public String toString() {
        return "DataSetListDependencyNode(id=" + this.getId() + ", name=" + this.getName() + ", dependencies=" + this.getDependencies() + ")";
    }

    public DataSetListDependencyNode() {
    }
}

