/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.jpa.model.PathStep;
import org.qubership.atp.dataset.service.jpa.model.tree.OverlapNode;

public class DataSetListParameterExtractor {
    private DataSetList dataSetList;
    private PathStep dataSetPath;
    private List<PathStep> referenceAttributePath;
    private PathStep attributePath;
    private static final AttributeTypeName[] attributesToLoad = new AttributeTypeName[]{AttributeTypeName.TEXT, AttributeTypeName.ENCRYPTED, AttributeTypeName.LIST};

    public DataSetListParameterExtractor(DataSetList dataSetList, PathStep dataSetPath, List<PathStep> referenceAttributePath, PathStep attributePath) {
        this.dataSetList = dataSetList;
        this.dataSetPath = dataSetPath;
        this.referenceAttributePath = referenceAttributePath;
        this.attributePath = attributePath;
    }

    public String extract() throws DataSetServiceException {
        DataSet dataSet = this.dataSetPath.getId() != null ? this.dataSetList.getDataSetById(this.dataSetPath.getId()) : this.dataSetList.getDataSetByName(this.dataSetPath.getName());
        if (dataSet == null) {
            throw new DataSetServiceException("Wrong data set");
        }
        if (this.referenceAttributePath.isEmpty()) {
            List<Attribute> attributes = this.dataSetList.getAttributesByTypes(Arrays.asList(attributesToLoad));
            for (Attribute attribute : attributes) {
                if (!this.attributePath.matches(attribute.getName(), attribute.getId())) continue;
                return this.getStringValue(dataSet, attribute);
            }
        } else {
            PathStep searchingPath = this.referenceAttributePath.get(0);
            List<Attribute> dataSetListReferences = this.dataSetList.getDataSetListReferences();
            OverlapNode rootOverlapNode = new OverlapNode(null, this.dataSetList.getId(), 1);
            List<AttributeKey> overlaps = this.dataSetList.getAttributeKeysByDataSet(dataSet.getId());
            for (AttributeKey overlap : overlaps) {
                rootOverlapNode.addOverlap(overlap.getPath(), 0, overlap);
            }
            for (Attribute dataSetListReference : dataSetListReferences) {
                if (!searchingPath.matches(dataSetListReference.getName(), dataSetListReference.getId())) continue;
                LinkedList<UUID> currentPath = new LinkedList<UUID>();
                currentPath.add(dataSetListReference.getId());
                return this.getParameterFromGroup(dataSet, dataSetListReference, rootOverlapNode, currentPath, this.referenceAttributePath.subList(1, this.referenceAttributePath.size()), this.attributePath);
            }
        }
        throw new DataSetServiceException("Parameter not found");
    }

    private String getStringValue(DataSet dataSet, Attribute attribute) {
        Parameter parameter = null;
        if (dataSet != null) {
            parameter = dataSet.getParameterByAttributeId(attribute.getId());
        }
        if (parameter == null) {
            return null;
        }
        return parameter.getParameterValueByType();
    }

    private String getParameterFromGroup(DataSet previousDataSet, Attribute dataSetListReference, OverlapNode rootOverlapNode, List<UUID> currentPath, List<PathStep> referenceAttributePath, PathStep attributePath) throws DataSetServiceException {
        DataSet thisLevelDataSet = null;
        DataSetList thisLevelDataSetList = dataSetListReference.getTypeDataSetList();
        AttributeKey overlap = rootOverlapNode.getOverlap(currentPath, 0, dataSetListReference.getId());
        if (overlap != null) {
            thisLevelDataSet = overlap.getParameter().getDataSetReferenceValue();
        }
        if (thisLevelDataSet == null && previousDataSet != null) {
            List<Parameter> parameters = dataSetListReference.getParameters();
            for (Parameter parameter : parameters) {
                UUID dataSetReferenceId = parameter.getDataSetReferenceId();
                if (!dataSetReferenceId.equals(previousDataSet.getId())) continue;
                thisLevelDataSet = parameter.getDataSet();
                break;
            }
        }
        if (referenceAttributePath.isEmpty()) {
            List<Attribute> attributes = thisLevelDataSetList.getAttributesByTypes(Arrays.asList(attributesToLoad));
            for (Attribute attribute : attributes) {
                if (!attributePath.matches(attribute.getName(), attribute.getId())) continue;
                AttributeKey parameterOverlap = rootOverlapNode.getOverlap(currentPath, 0, attribute.getId());
                if (parameterOverlap != null) {
                    return parameterOverlap.getParameter().getParameterValueByType();
                }
                return this.getStringValue(thisLevelDataSet, attribute);
            }
        } else {
            PathStep searchingPath = referenceAttributePath.get(0);
            List<Attribute> references = thisLevelDataSetList.getDataSetListReferences();
            for (Attribute reference : references) {
                if (!searchingPath.matches(reference.getName(), reference.getId())) continue;
                if (thisLevelDataSet != null) {
                    this.dataSetList.getAttributeKeysByDataSet(thisLevelDataSet.getId()).forEach(attributeKey -> rootOverlapNode.addOverlap(attributeKey.getPath(), 0, (AttributeKey)attributeKey));
                }
                currentPath.add(reference.getId());
                return this.getParameterFromGroup(thisLevelDataSet, reference, rootOverlapNode, currentPath, referenceAttributePath.subList(1, referenceAttributePath.size()), attributePath);
            }
        }
        throw new DataSetServiceException("Parameter not found");
    }
}

