/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.dscontext;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;
import org.qubership.atp.dataset.service.jpa.delegates.Label;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.service.jpa.model.dscontext.ParameterContext;
import org.qubership.atp.dataset.service.jpa.model.tree.OverlapNode;

public class DataSetContext
implements Serializable {
    private static final long serialVersionUID = -7846470332343480118L;
    private UUID id;
    private String name;
    private List<UUID> parentPath;
    private List<ParameterContext> parameters = new LinkedList<ParameterContext>();
    private Map<UUID, String> labels = new LinkedHashMap<UUID, String>();
    private int columnNumber;

    public DataSetContext(int dataSetColumnNumber, DataSet dataSet, List<Attribute> parentAttributes, OverlapNode overlaps, List<UUID> parentPath, List<UUID> pathRestrictions) {
        this.parentPath = parentPath;
        this.columnNumber = dataSetColumnNumber;
        this.id = dataSet.getId();
        this.name = dataSet.getName();
        if (pathRestrictions != null && !pathRestrictions.isEmpty()) {
            return;
        }
        for (Label label : dataSet.getLabels()) {
            this.labels.put(label.getId(), label.getName());
        }
        for (Attribute parentTextAttribute : parentAttributes) {
            boolean valueIsEmpty = true;
            List<Parameter> parametersModels = dataSet.getParameters();
            for (Parameter parameterModel : parametersModels) {
                AttributeKey overlap;
                boolean overlapped = false;
                if (overlaps != null && (overlap = overlaps.getOverlap(parentPath, dataSetColumnNumber, parentTextAttribute.getId())) != null) {
                    parameterModel = overlap.getParameter();
                    overlapped = overlap.getDataSetList().getId().equals(overlaps.getDataSetListId());
                }
                if (!parameterModel.getAttributeId().equals(parentTextAttribute.getId())) continue;
                this.parameters.add(new ParameterContext(parentTextAttribute, parameterModel, overlapped));
                valueIsEmpty = false;
                break;
            }
            if (!valueIsEmpty) continue;
            if (overlaps != null) {
                AttributeKey overlap = overlaps.getOverlap(parentPath, dataSetColumnNumber, parentTextAttribute.getId());
                if (overlap != null) {
                    boolean overlapped = overlap.getDataSetList().getId().equals(overlaps.getDataSetListId());
                    this.parameters.add(new ParameterContext(parentTextAttribute, overlap.getParameter(), overlapped));
                    continue;
                }
                this.parameters.add(new ParameterContext(parentTextAttribute));
                continue;
            }
            this.parameters.add(new ParameterContext(parentTextAttribute));
        }
    }

    public DataSetContext(int dataSetColumnNumber, List<Attribute> parentAttributes, OverlapNode overlaps, List<UUID> parentPath, List<UUID> pathRestrictions) {
        this.columnNumber = dataSetColumnNumber;
        this.parentPath = parentPath;
        this.id = null;
        this.name = "";
        if (pathRestrictions != null && !pathRestrictions.isEmpty()) {
            return;
        }
        for (Attribute parentTextAttribute : parentAttributes) {
            if (overlaps == null) continue;
            AttributeKey overlap = overlaps.getOverlap(parentPath, dataSetColumnNumber, parentTextAttribute.getId());
            if (overlap != null) {
                this.parameters.add(new ParameterContext(parentTextAttribute, overlap.getParameter(), true));
                continue;
            }
            this.parameters.add(new ParameterContext(parentTextAttribute));
        }
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<UUID> getParentPath() {
        return this.parentPath;
    }

    public List<ParameterContext> getParameters() {
        return this.parameters;
    }

    public Map<UUID, String> getLabels() {
        return this.labels;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParentPath(List<UUID> parentPath) {
        this.parentPath = parentPath;
    }

    public void setParameters(List<ParameterContext> parameters) {
        this.parameters = parameters;
    }

    public void setLabels(Map<UUID, String> labels) {
        this.labels = labels;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }
}

