/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.dsllazyload.referencedcontext;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.service.jpa.impl.DataSetParameterProvider;
import org.qubership.atp.dataset.service.jpa.model.dscontext.DataSetContext;
import org.qubership.atp.dataset.service.jpa.model.dscontext.DataSetListContext;
import org.qubership.atp.dataset.service.jpa.model.dscontext.GroupContext;
import org.qubership.atp.dataset.service.jpa.model.dscontext.ParameterContext;
import org.qubership.atp.dataset.service.jpa.model.dsllazyload.referencedcontext.RefDataSetListAttribute;

public class RefDataSetListFlat {
    private List<RefDataSetListAttribute> attributes = new LinkedList<RefDataSetListAttribute>();
    boolean isLastPage = false;

    public RefDataSetListFlat(DataSetListContext dataSetListContext, DataSetList dataSetList, List<UUID> path, DataSetParameterProvider parameterProvider) {
        GroupContext targetGroup = null;
        for (GroupContext group : dataSetListContext.getGroups()) {
            if (!group.getId().equals(path.get(0))) continue;
            targetGroup = this.getGroupByPath(group, path.subList(1, path.size()));
        }
        if (targetGroup != null) {
            this.isLastPage = targetGroup.isLastPage();
            List<Attribute> attributes = targetGroup.getAttributes();
            List<DataSetContext> dataSets = targetGroup.getDataSets();
            for (Attribute attribute : attributes) {
                LinkedHashMap<UUID, ParameterContext> parameters = new LinkedHashMap<UUID, ParameterContext>();
                for (DataSetContext dataSet : dataSets) {
                    for (ParameterContext parameter : dataSet.getParameters()) {
                        if (!attribute.getId().equals(parameter.getAttributeId())) continue;
                        DataSet dataSetByColumn = dataSetList.getDataSetByColumn(dataSet.getColumnNumber());
                        parameters.put(dataSetByColumn.getId(), parameter);
                    }
                }
                this.attributes.add(new RefDataSetListAttribute(attribute, parameters, targetGroup.getCurrentPath(), parameterProvider, dataSetListContext.getDataSetListId()));
            }
        }
    }

    public RefDataSetListFlat(DataSetListContext dataSetListContext, DataSetList dataSetList, List<UUID> path, DataSetParameterProvider parameterProvider, boolean isLastPage) {
        this(dataSetListContext, dataSetList, path, parameterProvider);
        this.setLastPage(isLastPage);
    }

    private GroupContext getGroupByPath(GroupContext groupContext, List<UUID> path) {
        if (path.isEmpty()) {
            return groupContext;
        }
        for (GroupContext group : groupContext.getGroups()) {
            if (!group.getId().equals(path.get(0))) continue;
            return this.getGroupByPath(group, path.subList(1, path.size()));
        }
        return null;
    }

    private Map<UUID, UUID> generateParentsToChildrenMap(List<DataSet> dataSets, List<Parameter> parameters) {
        HashMap<UUID, UUID> result = new HashMap<UUID, UUID>();
        for (DataSet dataSet : dataSets) {
            UUID childDataSetId = null;
            for (Parameter parameter : parameters) {
                if (!parameter.getDataSetId().equals(dataSet.getId())) continue;
                childDataSetId = parameter.getDataSetReferenceId();
                break;
            }
            result.put(dataSet.getId(), childDataSetId);
        }
        return result;
    }

    public List<RefDataSetListAttribute> getAttributes() {
        return this.attributes;
    }

    public boolean isLastPage() {
        return this.isLastPage;
    }

    public void setAttributes(List<RefDataSetListAttribute> attributes) {
        this.attributes = attributes;
    }

    public void setLastPage(boolean isLastPage) {
        this.isLastPage = isLastPage;
    }
}

